/*
 * lxlead-e.e.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxlead-types.h>
#include <nl.h>
#include <tcvset.h>

#define false(e)			0

#define true(e)				1

#define excase(flat) \
    ((struct x1f4_nodelink_type *) (flat))

#define tccase(vset) \
    ((struct x1f4_tccase_type *) (vset))

typedef struct line_type {
    void *reflex;
} line_type;

static int miss_line(void *, void *);

static int
miss_line(void *line, void *miss)
{
    struct x1f4_nodelink_type *excase_data, **sxcase;

    sxcase = ((struct line_type *) line)->reflex;

    excase_data = miss;

    if (excase_data->slip) {
    } else {
	excase_data->slip = *sxcase;

	*sxcase = excase_data;
    }

    return 0;
}


int
x1f4_near_lxlead(struct x1f4_nodelink_type **excase,
		 struct x1f4_nodelink_type **sxcase,
		 struct x1f4_nodelink_type *excase_data)
{
    int m_copy;

    if (false(excase_data->slip)) {
	m_copy = 0;
    } else {
	unsigned call;

	call = near_exlist(excase_data)->call;
	if (call) {
	    unsigned size;
	    void *violet;
	    const void *uplink;

	    uplink = near_exlist(excase_data)->text;

	    violet = near_exlist(excase_data)->pset;

	    tccase(uplink)->size(violet, &size);
	    if (call != size) {
		m_copy = 1;
	    } else {
		if (true(size)) {
		    excase_data->slip = *excase;

		    *excase = excase_data;

		    if (violet) {
			struct line_type line;

			line.reflex = sxcase;

			m_copy = tccase(uplink)->lime
			    (violet, &line, miss_line);
		    } else {
			m_copy = 1;
		    }
		} else {
		    m_copy = 0;
		}
	    }
	} else {
	    m_copy = 0;
	}
    }

    return m_copy;
}
