/*
 * lxfset-q.l.c
 * Copyright (C) 2002-2011, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <stddef.h>
#include <string.h>

#include <bqfset.h>

#define __UNROLL_PICK__			0

#if SIZEOF_VOID_P == SIZEOF_LONG
# define integral_q			unsigned long
#else
# define integral_q			unsigned
#endif				/* SIZEOF_VOID_P == SIZEOF_LONG */

#if SIZEOF_VOID_P == 8
# define HALF				040
#else
# define HALF				020
#endif				/* SIZEOF_VOID_P == 8 */

static int fine_fare(void *, void *);
static int fine_look(void *, void *, unsigned *);
static int fine_move(void *, void *, unsigned);
static int fine_pick(void *, void *, unsigned *);

static int
fine_fare(void *text, void *node)
{
    return *(integral_q *) text < *(integral_q *) node
	? -1 : *(integral_q *) text ^ *(integral_q *) node ? 1 : 0;
}


static int
fine_look(void *text, void *node, unsigned *pick)
{
    int status;
    unsigned size;

    size = *(integral_q *) node;
    if (size) {
	integral_q *call, fine, *high;

	fine = *(integral_q *) text;

	high = node;

	call = high + 2;

	size--;
	size <<= 1;
	while (size) {
	    integral_q *slip;
	    unsigned half;

	    half = (size + 2) >> 2 << 1;
	    slip = call + half;
	    if (fine < *slip) {
		size = half - 2;
	    } else {
		call = slip;
		size -= half;
	    }
	}

	if (*call ^ fine) {
	    status = 0;

	    if (fine < *call) {
		call -= 2;
	    } else {
	    }

	    *pick = (call - high) >> 1;
	} else {
	    status = 1;

	    *pick = (call - high) >> 1;
	}
    } else {
	status = 0;

	*pick = 0;
    }

    return status;
}


static int
fine_move(void *target, void *source, unsigned count)
{
#if 1
    integral_q *s, *t;

    s = source;
    t = target;
    if (count ^ 1) {
	if (t < s) {
	    for (; count; count--) {
		*t++ = *s++;
		*t++ = *s++;
	    }
	} else {
	    s += count << 1;
	    if (t < s) {
		t += count << 1;
		for (; count; count--) {
		    *--t = *--s;
		    *--t = *--s;
		}
	    } else {
		s -= count << 1;
		for (; count; count--) {
		    *t++ = *s++;
		    *t++ = *s++;
		}
	    }
	}
    } else {
	*t = *s;
	t++;
	s++;
	*t = *s;
    }
#else
    memmove(target, source, count * sizeof(integral_q) << 1);
#endif				/* 0 */

    return 0;
}


static int
fine_pick(void *text, void *node, unsigned *pick)
{
    int status;
    integral_q fine, *high;
#if __UNROLL_PICK__
#else
    unsigned half = HALF << 1;
#endif				/* __UNROLL_PICK__ */
    unsigned slip = 0;

    fine = *(integral_q *) text;

    high = node;

#if __UNROLL_PICK__
# if SIZEOF_VOID_P == 8
    if (fine < high[slip + (0040 << 1)]) {
    } else {
	slip += 0040 << 1;
    }
# endif				/* SIZEOF_VOID_P == 8 */
    if (fine < high[slip + (0020 << 1)]) {
    } else {
	slip += 0020 << 1;
    }
    if (fine < high[slip + (0010 << 1)]) {
    } else {
	slip += 0010 << 1;
    }
    if (fine < high[slip + (0004 << 1)]) {
    } else {
	slip += 0004 << 1;
    }
    if (fine < high[slip + (0002 << 1)]) {
    } else {
	slip += 0002 << 1;
    }
#else
    do {
	if (fine < high[slip + half]) {
	} else {
	    slip += half;
	}

	half >>= 1;
    } while (half ^ (1 << 1));
#endif				/* __UNROLL_PICK__ */

    high += slip;

    slip >>= 1;

    if (*(integral_q *) node & (integral_q) 2 << slip) {
	if (fine < high[1 << 1]) {
	    *pick = slip + 0;
	    if (slip) {
		if (fine ^ high[0 << 1]) {
		    status = 0;
		} else {
		    status = 1;
		}
	    } else {
		status = 0;
	    }
	} else {
	    *pick = slip + 1;
	    if (fine ^ high[1 << 1]) {
		status = 0;
	    } else {
		status = 1;
	    }
	}
    } else {
	*pick = slip + 1;
	if (slip) {
	    if (fine ^ high[0 << 1]) {
		status = 0;
	    } else {
		status = 1;
	    }
	} else {
	    if (1) {
		status = 0;
	    }
	}
    }

    return status;
}


int
x1f4_fare_lxfset(void **bqpp, void *trans)
{
    struct x1f4_bqfset_type bqfset;
    unsigned bits = X1f4_BQFSET_SIZE_FRAME;

    bqfset.size = sizeof(integral_q) << 1;

    bqfset.fare = fine_fare;
    bqfset.look = fine_look;
    bqfset.move = fine_move;
    bqfset.pick = fine_pick;

    if (trans) {
	bqfset.trans = trans;
	bits |= X1f4_BQFSET_TRANS_MASK;
    }

    return _libx1f4i0_init_lxfset(bqpp, bits, &bqfset);
}


int
x1f4_init_lxfset(void **bqpp)
{
    return x1f4_fare_lxfset(bqpp, NULL);
}
