/*
 * lxflat-types.h
 * Copyright (C) 2008-2010, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_lxflat_types_H__
#define __LIBx1f4_lxflat_types_H__

#include <time.h>

#include <dt.h>
#include <frame.h>
#include <track.h>
#include <trans.h>

typedef struct cxflat_type {
    const char *name;
    int type;
    unsigned size;
} cxflat_type;

typedef struct dxflat_type {
    unsigned call;
    void *data;
} dxflat_type;

/*
 * NOTES
 *
 *.some error recorder in addition to the error dumper is in good order.  such
 * recorder would record the error type (this library identification -
 * application side, since such identification is created by the application)
 * and the error details (library error type and details)
 */
typedef struct lxflat_type {
    struct x1f4_track_type link_e;
    struct {
	void *data, *side, *text;
    } link_f;
    struct {
	int (*call) (void *, void *);
	void *text;
    } link_h;
    struct {
	unsigned miss;
    } link_l;
    struct trans_type link_m;
    struct {
	struct x1f4_datatype_type *datatype_data;
    } link_t;
    struct x1f4_frame_type link_v;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_w;
} lxflat_type;

typedef struct screen_type {
    struct x1f4_track_type link_e;
    struct {
	int (*call) (void *, void *);
	void *text;
    } link_h;
    struct {
	struct cxflat_type *cxflat_data;
	unsigned miss;
    } link_l;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_m;
    struct x1f4_frame_type link_v;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_w;
} screen_type;

#endif				/* __LIBx1f4_lxflat_types_H__ */
