/*
 * lxflat-f.s.c
 * Copyright (C) 2008-2010, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <lxcall.h>
#include <lxflat-types.h>

#define I_FLAT(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_FLAT(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define lock_exdata(data) \
    (data)

int
_libx1f4i0_lxflat_s_forward(void *context, void *output, void **input)
{
    int status;
    struct dxflat_type *dxflat_text;
    struct lxflat_type *lxflat_data;

    dxflat_text = I_FLAT(input[1]);

    lxflat_data = context;

    status = _libx1f4i0_lxcall_near_node
	(&lxflat_data->link_v, &lxflat_data->link_e,
	 lxflat_data->link_t.datatype_data, I_FLAT(input[0]));
    if (status) {
    } else {
	lock_exdata(dxflat_text)->call++;

	l_FLAT(dxflat_text, input[0]);
	l_FLAT(dxflat_text, output);
    }

    return status;
}
