/*
 * lxflat-a.0.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <e4-m.0.h>
#include <e4.h>
#include <lxcall.h>
#include <lxflat-defs.h>
#include <lxflat-inter.h>
#include <lxflat-types.h>

#define MAKE_SINGLE(a, b)		a

#define cxflat(cxflat) \
    ((struct cxflat_type *) (cxflat))

static int init_flat(struct lxflat_type *, unsigned,
		     const struct screen_type *);
static int line_data(struct lxflat_type *, unsigned,
		     const struct screen_type *, void *, void **);
static int line_fail(struct lxflat_type *, unsigned, void *, void *);
static int line_flat(struct lxflat_type *, unsigned,
		     const struct screen_type *);
static int link_flat(struct lxflat_type *, unsigned,
		     const struct screen_type *);
static int pick_miss(unsigned *, unsigned *, const struct screen_type *);

static void line_sset(u_case_args_____0);

static const struct line_type ever_line[] = {
/* *INDENT-OFF* */
#define f_set_count			2
    {	{	"?_set",
		_libx1f4i0_lxflat_s_forward,	0,
		NULL,				f_set_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE
		| X1f4_E4_TEXT_LINK,
						5		},
	line_sset,							}
#define f_set_reach			(0 + (f_set_count << 1))
/* *INDENT-ON* */
#define ever_line_count			f_set_reach
};
static const struct x1f4_operator_type side_o[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("=", " "),  NULL,		0400,
	0,			NULL,
	X1f4_E4_BACK_LINK | X1f4_E4_E2ND_LINK | X1f4_E4_LEFT_XSET,
				1,
	NULL,			NULL					}
/* *INDENT-ON* */
};

static int
init_flat(struct lxflat_type *lxflat_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    int status;

    if (bits & ABSTRACT_LINK) {
	lxflat_data->link_h.call = screen_data->link_h.call;
	lxflat_data->link_h.text = screen_data->link_h.text;
    } else {
	lxflat_data->link_h.call = NULL;
    }

    if (bits & AUTOLINK_LINK) {
	lxflat_data->link_v.data = screen_data->link_v.data;
	lxflat_data->link_v.free = screen_data->link_v.free;
	lxflat_data->link_v.link = screen_data->link_v.link;
	lxflat_data->link_v.mode = screen_data->link_v.mode;
	lxflat_data->link_v.pick = screen_data->link_v.pick;
	lxflat_data->link_v.slip = screen_data->link_v.slip;
    } else {
	lxflat_data->link_v.data = NULL;
	lxflat_data->link_v.free = NULL;
	lxflat_data->link_v.link = NULL;
	lxflat_data->link_v.mode = NULL;
	lxflat_data->link_v.pick = NULL;
	lxflat_data->link_v.slip = NULL;
    }

    if (bits & CODELINK_LINK) {
	lxflat_data->link_w.data = screen_data->link_w.data;
	lxflat_data->link_w.free = screen_data->link_w.free;
	lxflat_data->link_w.link = screen_data->link_w.link;
	lxflat_data->link_w.mode = screen_data->link_w.mode;
    } else {
	lxflat_data->link_w.data = NULL;
	lxflat_data->link_w.free = _x1f4_e4_free_data;
	lxflat_data->link_w.link = _x1f4_e4_link_data;
	lxflat_data->link_w.mode = _x1f4_e4_mode_data;
    }

    if (1) {
	lxflat_data->link_l.miss = screen_data->link_l.miss;
    }

    if (bits & RESOURCE_LINK) {
	lxflat_data->link_m.data = screen_data->link_m.data;
	lxflat_data->link_m.free = screen_data->link_m.free;
	lxflat_data->link_m.link = screen_data->link_m.link;
	lxflat_data->link_m.mode = screen_data->link_m.mode;
    } else {
	lxflat_data->link_m.data = NULL;
	lxflat_data->link_m.free = _x1f4_e4_free_data;
	lxflat_data->link_m.link = _x1f4_e4_link_data;
	lxflat_data->link_m.mode = _x1f4_e4_mode_data;
    }

    if (bits & TEXTFLAT_LINK) {
	lxflat_data->link_e.data = screen_data->link_e.data;
	lxflat_data->link_e.line = screen_data->link_e.line;
	lxflat_data->link_e.post = screen_data->link_e.post;
	lxflat_data->link_e.push = screen_data->link_e.push;
    } else {
	lxflat_data->link_e.data = NULL;
	lxflat_data->link_e.line = NULL;
	lxflat_data->link_e.post = NULL;
	lxflat_data->link_e.push = NULL;
    }

    status = link_flat(lxflat_data, bits, screen_data);

    return status;
}


static int
line_data(struct lxflat_type *lxflat_data, unsigned bits,
	  const struct screen_type *screen_data, void *data, void **args)
{
    struct cxflat_type *cxflat_data;
    struct x1f4_linetext_type *linetext_data;
    unsigned miss;

    cxflat_data = screen_data->link_l.cxflat_data;
    miss = screen_data->link_l.miss;

    linetext_data = data;

    for (; miss; miss--) {
	if (bits & AUTOLINK_LINK) {
	    _libx1f4i0_lxcall_side_line
		(lxflat_data, bits, cxflat_data, linetext_data, args,
		 sizeof(ever_line) / sizeof(struct line_type), ever_line);
	    linetext_data += sizeof(ever_line) / sizeof(struct line_type);
	}

	cxflat_data++;
    }

    if (1) {
	_libx1f4i0_lxcall_zero_line(linetext_data);
    }

    return 0;
}


static int
line_fail(struct lxflat_type *lxflat_data, unsigned bits, void *side,
	  void *data)
{
    struct x1f4_operator_type **operator;
    struct x1f4_linetext_type *linetext_data;
    struct tide_type *tide_data;
    unsigned miss;

    miss = lxflat_data->link_l.miss;

    linetext_data = data;

    operator = side;

    tide_data = side;
    tide_data -= miss;

    for (; miss; miss--) {
	if (bits & AUTOLINK_LINK) {
	    *operator = &tide_data->operator;

	    tide_data->operator = side_o[0];
	    tide_data->operator.args = linetext_data->function.args;
	    tide_data->operator.type = linetext_data->function.type;
	    tide_data->operator.extension2 = &tide_data->tidespan;
	    tide_data->tidespan.bits = X1f4_E4_CALL_LINK;
	    tide_data->tidespan.line = linetext_data;

	    linetext_data++;

	    tide_data++;

	    operator++;
	}
    }

    *operator = NULL;

    return 0;
}


static int
line_flat(struct lxflat_type *lxflat_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    struct cxflat_type *cxflat_data;
    struct x1f4_datatype_type *datatype_data;
    unsigned miss;

    cxflat_data = screen_data->link_l.cxflat_data;
    miss = screen_data->link_l.miss;

    datatype_data = lxflat_data->link_t.datatype_data;

    for (; miss; miss--) {
	datatype_data->context = lxflat_data;

	datatype_data->flat = _libx1f4i0_lxflat_flat_flat;
	datatype_data->lead = _libx1f4i0_lxflat_lead_flat;
	datatype_data->line = _libx1f4i0_lxflat_line_flat;
	datatype_data->link = _libx1f4i0_lxflat_link_flat;
	datatype_data->name = cxflat_data->name;
	datatype_data->shut = _libx1f4i0_lxflat_flat_flat;
	datatype_data->slip = _libx1f4i0_lxflat_slip_flat;
	datatype_data->size = cxflat_data->size;
	datatype_data->type = cxflat_data->type;

	cxflat_data++;

	datatype_data++;
    }

    {
	datatype_data->context = NULL;

	datatype_data->flat = NULL;
	datatype_data->lead = NULL;
	datatype_data->line = NULL;
	datatype_data->link = NULL;
	datatype_data->name = NULL;
	datatype_data->shut = NULL;
	datatype_data->slip = NULL;
	datatype_data->size = 0;
	datatype_data->type = 0;
    }

    return 0;
}


static int
link_flat(struct lxflat_type *lxflat_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    int status;
    unsigned args_class, line_class, miss;
    void *data;

    pick_miss(&args_class, &line_class, screen_data);

    miss = screen_data->link_l.miss;

    status = lxflat_data->link_w.link
	(lxflat_data->link_w.data, &data,
	 (args_class * sizeof(int) + sizeof(struct x1f4_datatype_type)
	  + line_class * sizeof(struct x1f4_linetext_type)
	  + sizeof(struct tide_type) + sizeof(struct x1f4_operator_type *))
	 * miss + sizeof(struct x1f4_datatype_type)
	 + sizeof(struct x1f4_linetext_type)
	 + sizeof(struct x1f4_operator_type *));
    if (status) {
	status = LINK_ERROR;
    } else {
	void *args, *flat, *side;

	flat = (struct x1f4_linetext_type *) data + miss * line_class + 1;
	side = (struct x1f4_datatype_type *) flat + miss + 1;
	side = (struct tide_type *) side + miss;
	args = (struct x1f4_operator_type **) side + miss + 1;

	lxflat_data->link_f.data =
	    (struct x1f4_linetext_type *) data + miss * line_class;
	lxflat_data->link_f.side = side;
	lxflat_data->link_f.text = data;

	lxflat_data->link_t.datatype_data = flat;

	line_data(lxflat_data, bits, screen_data, data, &args);
	line_fail(lxflat_data, bits, side, data);

	line_flat(lxflat_data, bits, screen_data);
    }

    return status;
}


static int
pick_miss(unsigned *args, unsigned *line,
	  const struct screen_type *screen_data)
{
    unsigned args_count = 0, line_count = 0;

    args_count += ever_line_count;
    line_count += sizeof(ever_line) / sizeof(struct line_type);

    *args = args_count;
    *line = line_count;

    return 0;
}


static void
line_sset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = cxflat(screen)->type;
    *line++ = cxflat(screen)->type;
    *line++ = X1f4_E4_POST_XSET;
    *line++ = 0;

    *args = line;

    linetext_data->function.type = cxflat(screen)->type;
}


int
x1f4_init_lxflat(void **lxflat, unsigned bits,
		 const struct screen_type *screen_data)
{
    int (*link) (void *, void **, unsigned), status;
    void *data, *text;

    if (bits & CODELINK_LINK) {
	link = screen_data->link_w.link;
	text = screen_data->link_w.data;
    } else {
	link = _x1f4_e4_link_data;
	text = (void *) 0;
    }

    status = link(text, &data, sizeof(struct lxflat_type));
    if (status) {
	status = LINK_ERROR;
    } else {
	status = init_flat(data, bits, screen_data);
	if (status) {
	    if (bits & CODELINK_LINK) {
		screen_data->link_w.free(text, data);
	    } else {
		_x1f4_e4_free_data(text, data);
	    }
	} else {
	    *lxflat = data;
	}
    }

    return status;
}
