/*
 * lxfile.h
 * Copyright (C) 2008-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_lxfile_H__
#define __LIBx1f4_lxfile_H__

#include <dt.h>
#include <lxnote.h>
#include <nl.h>
#include <nt.h>
#include <trans.h>

/*
 * error definitions
 */
#define X1f4_LXFILE_FREE_ERROR		-2
#define X1f4_LXFILE_LINK_ERROR		-3
#define X1f4_LXFILE_MODE_ERROR		-4

/*
 * file mode definitions
 */
#define X1f4_LXFILE_PUSH_CLASS		1
#define X1f4_LXFILE_READ_CLASS		2

/*
 * generation flag definitions
 */
#define X1f4_LXFILE_AUTOLINK		(1L << 0)
#define X1f4_LXFILE_CODELINK		(1L << 1)
#define X1f4_LXFILE_DATALINK		(1L << 2)
#define X1f4_LXFILE_EVERLINK		(1L << 3)
#define X1f4_LXFILE_LISTLINK		(1L << 4)
#define X1f4_LXFILE_MISSOPEN		(1L << 5)
#define X1f4_LXFILE_RESOURCE		(1L << 6)
#define X1f4_LXFILE_SETCLOSE		(1L << 7)
#define X1f4_LXFILE_TEXTFLAT		(1L << 8)

/*
 * posh flag definitions
 */
#define X1f4_LXFILE_POSH_BLOCK		(1L << 0)

#if !defined __x1f4_function_type_defined__
typedef struct x1f4_function_type {
    const char *name;
    int (*function) (void *, void *, void **), type;
    const int *args;
    unsigned count, flags, length;
} x1f4_function_type;
#endif				/* !__x1f4_function_type_defined__ */

#if !defined __x1f4_function_type_defined__
# define __x1f4_function_type_defined__
#endif				/* !__x1f4_function_type_defined__ */

#if !defined __x1f4_linetext_type_defined__
typedef struct x1f4_linetext_type {
    struct x1f4_function_type function;
    const void *context;
} x1f4_linetext_type;
#endif				/* !__x1f4_linetext_type_defined__ */

#if !defined __x1f4_linetext_type_defined__
# define __x1f4_linetext_type_defined__
#endif				/* !__x1f4_linetext_type_defined__ */

typedef struct x1f4_dxfile_type {
    int mode;
    unsigned call;
    void *file;
    const void *socket;
} x1f4_dxfile_type;

typedef struct x1f4_lxfile_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } textflat_set;
    struct {
	int type;
    } datalink_set;
    struct {
	int type;
    } listlink_set;
    struct {
	int type;
    } filetype_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } resource_set;
    struct x1f4_trans_type codelink_set;
} x1f4_lxfile_type;

extern int x1f4_bill_dxfile(struct x1f4_dxfile_type *, int *);
extern int x1f4_dset_lxfile(void *, const struct x1f4_datatype_type **);
extern int x1f4_fini_lxfile(void **);
extern int x1f4_flat_lxfile(void *, void **);
extern int x1f4_free_lxfile
    (void *, void *, struct x1f4_nodelink_type **,
     const struct x1f4_nodelink_type *);
extern int x1f4_fset_lxfile(void *, const struct x1f4_linetext_type **);
extern int x1f4_init_lxfile
    (void **, unsigned, const struct x1f4_lxfile_type *);
extern int x1f4_lead_lxfile(void *, void **);
extern int x1f4_line_lxfile(void *, void **);
extern int x1f4_list_lxfile(void *, void *);
extern int x1f4_long_dxfile(void *, struct x1f4_dxfile_type *, int *);
extern int x1f4_lose_dxfile(void *, struct x1f4_dxfile_type *);
extern int x1f4_node_lxfile
    (void *, void **, void *, const struct x1f4_nodelink_type *);
extern int x1f4_note_lxfile(const struct x1f4_lxnote_type **);
extern int x1f4_pick_dxfile(void *, struct x1f4_dxfile_type *, int);
extern int x1f4_pipe_lxfile(void *, const char *, unsigned);
extern int x1f4_posh_dxfile(void *, struct x1f4_dxfile_type *, int, unsigned);
extern int x1f4_push_lxfile
    (void *, void *, void **, void *, const struct x1f4_nodelink_type *);
extern int x1f4_slip_lxfile(void *, void **);
extern int x1f4_type_lxfile(struct x1f4_nodetype_type *);
extern int x1f4_vset_lxfile(void **);

#endif				/* __LIBx1f4_lxfile_H__ */
