/*
 * lxfile-s.s.c
 * Copyright (C) 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <c1.h>
#include <e4.h>
#include <lxfile-defs.h>
#include <lxfile-inter.h>
#include <lxfile-types.h>

#define I_FILE(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_MODE(e, output) \
    {									      \
	X1f4_E4_C_MODE *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define exfile(file) \
    ((struct exfile_type *) (file)->socket)

int
_libx1f4i0_lxfile_s_sequent(void *context, void *output, void **input)
{
    int stored;
    struct dxfile_type *dxfile_data;
    void *file;

    dxfile_data = I_FILE(input[0]);

    file = dxfile_data->file;
    if (file) {
	int (*lift) (void *, int *);

	lift = exfile(dxfile_data)->lift;
	if (lift) {
	    lift(file, &stored);
	} else {
	    stored = 0;
	}
    } else {
	stored = 0;
    }

    l_MODE(stored, output);

    return 0;
}
