/*
 * lxfile-l.a.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <fcntl.h>
#include <stddef.h>

#include <e4.h>
#include <file.h>
#include <lxfile-defs.h>
#include <lxfile-inter.h>
#include <lxfile-types.h>

#define I_FILE(t)			(*((X1f4_E4_C_USER *) (t)))

int
_libx1f4i0_lxfile_a_logique(void *context, void *output, void **input)
{
    int status;

    do {
	X1f4_E4_C_MODE bits, mode;
	struct dxfile_type *dxfile_data;
	struct lxfile_type *lxfile_data;
	void *scope[4];

	dxfile_data = I_FILE(input[0]);

	lxfile_data = context;

	if (dxfile_data->file) {
	    status = x1f4_lose_dxfile(lxfile_data, dxfile_data);
	    if (status) {
		break;
	    }
	}

	scope[0] = input[0];
	scope[1] = input[1];
	scope[2] = &bits;
	scope[3] = &mode;

	mode = 0;

	bits = O_RDONLY;

	status = _libx1f4i0_lxfile_pull_file
	    (lxfile_data, dxfile_data, O_RDONLY, scope);
    } while (0);

    return status;
}
