/*
 * lxfile-i.a.c
 * Copyright (C) 2008-2010, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <c1.h>
#include <e4.h>
#include <file.h>
#include <lxcall.h>
#include <lxfile-inter.h>
#include <lxfile-types.h>

#define l_MODE(e, output) \
    {									      \
	X1f4_E4_C_MODE *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define l_TEXT(e, output) \
    {									      \
	const X1f4_E4_C_TEXT *l;					      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define lxfile(lxfile) \
    ((struct lxfile_type *) (lxfile))

int
_libx1f4i0_lxfile_land_line(void *lxfile, int status, void *data,
			    unsigned size, void *output, void *store)
{
    if (status) {
	if (status == FILE_OVER_CLASS) {
	    status = _libx1f4i0_lxcall_pick_text
		(&lxfile(lxfile)->link_v, &lxfile(lxfile)->link_m,
		 &lxfile(lxfile)->link_e, store);
	    if (status) {
	    } else {
		l_MODE(-1, output);
		l_TEXT(x1f4_c1_empty_string, store);
	    }
	} else {
	    if (status == FILE_HALF_CLASS) {
		status = _libx1f4i0_lxcall_pick_text
		    (&lxfile(lxfile)->link_v, &lxfile(lxfile)->link_m,
		     &lxfile(lxfile)->link_e, store);
		if (status) {
		} else {
		    l_MODE(-2, output);
		    l_TEXT(x1f4_c1_empty_string, store);
		}
	    } else {
		status = _libx1f4i0_lxfile_stat_file(lxfile, status);
	    }
	}
    } else {
	status = _libx1f4i0_lxcall_pick_text
	    (&lxfile(lxfile)->link_v, &lxfile(lxfile)->link_m,
	     &lxfile(lxfile)->link_e, store);
	if (status) {
	} else {
	    l_MODE(size, output);
	    l_TEXT(data, store);
	}
    }

    return status;
}
