/*
 * lxfile-f.s.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <c1.h>
#include <e4.h>
#include <file.h>
#include <lxfile-defs.h>
#include <lxfile-inter.h>
#include <lxfile-types.h>

#define I_FILE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))

#define l_MODE(e, output) \
    {									      \
	X1f4_E4_C_MODE *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

int
_libx1f4i0_lxfile_s_forward(void *context, void *output, void **input)
{
    int status;

    do {
	X1f4_E4_C_MODE call;
	struct dxfile_type *dxfile_data;
	void *file;

	dxfile_data = I_FILE(input[0]);

	call = I_MODE(input[1]);

	file = dxfile_data->file;
	if (file) {
	    unsigned skip;

	    if (dxfile_data->mode != READ_CLASS) {
		status = _libx1f4i0_lxfile_stat_node(context);
		if (1) {
		    break;
		}
	    }

	    if (call < 0) {
		status = _libx1f4i0_lxfile_stat_skip(context, call);
		if (1) {
		    break;
		}
	    }

	    status = _libx1f4i0_skip_ifile(file, call, &skip);
	    if (status) {
		if (status == FILE_OVER_CLASS) {
		    status = 0;

		    l_MODE(-1, output);
		} else {
		    status = _libx1f4i0_lxfile_stat_file
			(context, status);
		}
	    } else {
		l_MODE(skip, output);
	    }
	} else {
	    status = _libx1f4i0_lxfile_stat_null(context);
	}
    } while (0);

    return status;
}
