/*
 * lxfile-e.n.c
 * Copyright (C) 2008-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <file.h>
#include <lxfile-defs.h>
#include <lxfile-types.h>

extern const struct exfile_type _libx1f4_lxfile_o_file;

int
x1f4_omap_lxfile(void *lxfile, void *dxfile, int fd)
{
    int status;
    struct dxfile_type *dxfile_data;
    struct lxfile_type *lxfile_data;
    unsigned size;
    void *file;

    lxfile_data = lxfile;

    dxfile_data = dxfile;

    _libx1f4i0_size_ofile(&size);

    status = lxfile_data->link_m.link(lxfile_data->link_m.data, &file, size);
    if (status) {
	status = LINK_ERROR;
    } else {
	_libx1f4i0_fset_ofile(file, fd);
	if (0) {
	} else {
	    dxfile_data->file = file;

	    dxfile_data->mode = PUSH_CLASS;

	    dxfile_data->socket = &_libx1f4_lxfile_o_file;

#if 0
	    if (lxfile_data->link_i.bits & SETCLOSE_LINK) {
		status = _libx1f4i0_fine_ofile(file);
		if (status) {
		    /*
		     * TODO
		     *
		     * invent an error?
		     */
		    status = 0;
		}
	    }
#endif				/* 0 */
	}
    }

    return status;
}
