/*
 * lxfile-defs.h
 * Copyright (C) 2008-2010, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_lxfile_defs_H__
#define __LIBx1f4_lxfile_defs_H__

/*
 * error definitions
 */
#define FREE_ERROR			-2
#define LINK_ERROR			-3
#define MODE_ERROR			-4

/*
 * file mode definitions
 */
#define PUSH_CLASS			1
#define READ_CLASS			2

/*
 * file open definitions
 */
#define OPEN_APPEND			(1L << 0)
#define OPEN_CREATE			(1L << 1)
#define OPEN_NONBLOCKING		(1L << 2)
#define OPEN_READONLY			(1L << 3)
#define OPEN_3				(1L << 4)
#define OPEN_TRUNCATE			(1L << 5)
#define OPEN_WRITEONLY			(1L << 6)

/*
 * file open definitions (concluded)
 */
#define OPEN_Z				(1L << 7)

/*
 * generation flag definitions
 */
#define AUTOLINK_LINK			(1L << 0)
#define CODELINK_LINK			(1L << 1)
#define DATALINK_LINK			(1L << 2)
#define EVERLINK_SLIP			(1L << 3)
#define LISTLINK_LINK			(1L << 4)
#define MISSOPEN_SLIP			(1L << 5)
#define RESOURCE_LINK			(1L << 6)
#define SETCLOSE_LINK			(1L << 7)
#define TEXTFLAT_LINK			(1L << 8)

/*
 * posh flag definitions
 */
#define POSH_BLOCK			(1L << 0)

#endif				/* __LIBx1f4_lxfile_defs_H__ */
