/*
 * lxfile-d.m.c
 * Copyright (C) 2008-2010, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <file.h>
#include <lxfile-defs.h>
#include <lxfile-inter.h>
#include <lxfile-types.h>
#include <trans.h>

#define I_FILE(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

int
_libx1f4i0_lxfile_m_derived(void *context, void *output, void **input)
{
    int status;

    do {
	struct dxfile_type *dxfile_data;
	struct lxfile_type *lxfile_data;
	void *file;

	dxfile_data = I_FILE(input[0]);

	lxfile_data = context;

	file = dxfile_data->file;
	if (file) {
	    char *text;
#if __TRANS_FILE_LX_DEFINITION__
#else
	    struct trans_type trans;
#endif				/* __TRANS_FILE_LX_DEFINITION__ */
	    unsigned side[8], size;
	    void *data;

	    if (dxfile_data->mode != READ_CLASS) {
		status = _libx1f4i0_lxfile_stat_node(lxfile_data);
		if (1) {
		    break;
		}
	    }

	    text = I_TEXT(input[1]);

	    side[0] = ~0;
	    side[1] = ~0;
	    side[2] = ~0;
	    side[3] = ~0;
	    side[4] = ~0;
	    side[5] = ~0;
	    side[6] = ~0;
	    side[7] = ~0;

	    if (1) {
		unsigned c;

		c = *(unsigned char *) text;
		while (c) {
		    side[c >> 5] &= ~(1 << (c & 31));
		    text++;
		    c = *(unsigned char *) text;
		}
	    }

#if __TRANS_FILE_LX_DEFINITION__
#else
	    trans.data = lxfile_data->link_m.data;
	    trans.free = lxfile_data->link_m.free;
	    trans.link = lxfile_data->link_m.link;
	    trans.mode = lxfile_data->link_m.mode;
#endif				/* __TRANS_FILE_LX_DEFINITION__ */

#if __TRANS_FILE_LX_DEFINITION__
	    status = _libx1f4i0_fast_ifile
		(file, side, &data, &size, &lxfile_data->link_m);
#else
	    status = _libx1f4i0_fast_ifile(file, side, &data, &size, &trans);
#endif				/* __TRANS_FILE_LX_DEFINITION__ */
	    status = _libx1f4i0_lxfile_land_line
		(lxfile_data, status, data, size, output, input[2]);
	} else {
	    status = _libx1f4i0_lxfile_stat_null(context);
	}
    } while (0);

    return status;
}
