/*
 * lxfile-a.r.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <lxfile-inter.h>
#include <lxfile-types.h>

#define dxfile(file) \
    ((struct dxfile_type *) (file))

int
x1f4_shut_lxfile(void *subtext, void **address)
{
    int status;
    void *file;

    file = *address;
    if (file) {
	unsigned call;

	call = dxfile(file)->call;
	call--;
	if (call) {
	    dxfile(file)->call = call;

	    *address = NULL;

	    status = 0;
	} else {
	    status = _libx1f4i0_lxfile_miss_file(subtext, file);
	    if (status) {
	    } else {
		*address = NULL;
	    }
	}
    } else {
	status = 0;
    }

    return status;
}
