/*
 * lxfile-a.p.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <file.h>
#include <lxfile-defs.h>
#include <lxfile-inter.h>
#include <lxfile-types.h>

int
x1f4_pipe_lxfile(void *context, const char *data, unsigned size)
{
    int status;

    do {
	struct dxfile_type *dxfile_data;
	void *file;

	dxfile_data = *((void **) context + 1);

	file = dxfile_data->file;
	if (file) {
	    if (dxfile_data->mode != PUSH_CLASS) {
		status = _libx1f4i0_lxfile_stat_line(*(void **) context);
		if (1) {
		    break;
		}
	    }

	    status = _libx1f4i0_push_ofile(file, (void *) data, size);
	    if (status) {
		status =
		    _libx1f4i0_lxfile_stat_file(*(void **) context, status);
	    }
	} else {
	    status = _libx1f4i0_lxfile_stat_love(*(void **) context);
	}
    } while (0);

    return status;
}
