/*
 * lxfile-a.l.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <lxfile-inter.h>
#include <lxfile-types.h>

#define exfile(file) \
    ((struct exfile_type *) (file)->socket)

int
x1f4_lose_dxfile(struct lxfile_type *lxfile_data,
		 struct dxfile_type *dxfile_data)
{
    int status;
    void *file;

    file = dxfile_data->file;
    if (file) {
	status = exfile(dxfile_data)->lose(file);
	if (status) {
	    status = _libx1f4i0_lxfile_stat_file(lxfile_data, status);
	} else {
	    status = lxfile_data->link_m.free(lxfile_data->link_m.data, file);
	    if (status) {
		status = _libx1f4i0_lxfile_stat_free(lxfile_data);
	    } else {
		dxfile_data->file = NULL;
	    }
	}
    } else {
	status = 0;
    }

    return status;
}
