/*
 * lxfile-a.k.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <file.h>
#include <lxfile-inter.h>
#include <lxfile-types.h>

#define exfile(file) \
    ((struct exfile_type *) (file)->socket)

int
x1f4_long_dxfile(void *context, struct dxfile_type *dxfile_data, int *class)
{
    int status;
    void *file;

    file = dxfile_data->file;
    if (file) {
	int excess;

	excess = _libx1f4i0_long_ofile(file);
	if (excess == FILE_PUSH_CLASS) {
	    status = _libx1f4i0_lxfile_stat_file(context, excess);
	} else {
	    status = 0;
	    *class = excess;
	}
    } else {
	status = _libx1f4i0_lxfile_stat_love(context);
    }

    return status;
}
