/*
 * lxfile-a.g.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <lxfile-inter.h>
#include <lxfile-types.h>

int
x1f4_line_lxfile(void *subtext, void **address)
{
    int status;
    struct lxfile_type *lxfile_data;
    void *dxfile;

    lxfile_data = subtext;

    status = lxfile_data->link_m.link
	(lxfile_data->link_m.data, &dxfile, sizeof(struct dxfile_type));
    if (status) {
	status = _libx1f4i0_lxfile_stat_link(lxfile_data);
    } else {
	((struct dxfile_type *) dxfile)->call = 1;

	((struct dxfile_type *) dxfile)->file = NULL;

	*address = dxfile;
    }

    return status;
}
