/*
 * lxfile-a.e.c
 * Copyright (C) 2008-2010, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <errno.h>
#include <string.h>

#include <er.h>
#include <exerrors.h>
#include <file.h>
#include <lxfile-inter.h>
#include <lxfile-types.h>

#define false(e)			0

#define lxfile(lxfile) \
    ((struct lxfile_type *) (lxfile))

int
_libx1f4i0_lxfile_stat_else(void *lxfile, const char *path)
{
    LINE_EEER(lxfile(lxfile)->link_e);

    PUSH_DATA("will not open `", 15);
    PUSH_TEXT(path);
    PUSH_DATA("' for both read exclusive and write exclusive were specified",
	      60);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxfile_stat_file(void *lxfile, int class)
{
    int status;

    if (class == FILE_LINK_CLASS) {
	status = _libx1f4i0_lxfile_stat_link(lxfile);
    } else {
	if (class == FILE_LOSE_CLASS) {
	    status = _libx1f4i0_lxfile_stat_lose(lxfile);
	} else {
	    if (class == FILE_MODE_CLASS) {
		status = _libx1f4i0_lxfile_stat_mode(lxfile);
	    } else {
		if (false(class == FILE_OPEN_CLASS)) {
		} else {
		    if (false(class == FILE_OVER_CLASS)) {
		    } else {
			if (class == FILE_PUSH_CLASS) {
			    status = _libx1f4i0_lxfile_stat_push(lxfile);
			} else {
			    if (class == FILE_READ_CLASS) {
				status = _libx1f4i0_lxfile_stat_read(lxfile);
			    } else {
				if (class == FILE_SEEK_CLASS) {
				    status =
					_libx1f4i0_lxfile_stat_seek(lxfile);
				} else {
				    if (class == FILE_ZERO_CLASS) {
					status = _libx1f4i0_lxfile_stat_zero
					    (lxfile);
				    } else {
					status = X1f4_EX_CRITICAL;
				    }
				}
			    }
			}
		    }
		}
	    }
	}
    }

    return status;
}


int
_libx1f4i0_lxfile_stat_fine(void *lxfile, const char *path)
{
    int error;

    error = errno;

    LINE_EEER(lxfile(lxfile)->link_e);

    PUSH_DATA("cannot set the close-on-exec flag on `", 38);
    PUSH_TEXT(path);
    PUSH_DATA("': ", 3);
    PUSH_TEXT(strerror(error));

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxfile_stat_free(void *lxfile)
{
    LINE_EEER(lxfile(lxfile)->link_e);

    PUSH_DATA("cannot free memory", 18);

    POST_EEER();

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxfile_stat_line(void *lxfile)
{
    LINE_EEER(lxfile(lxfile)->link_e);

    PUSH_DATA("cannot write: file open read-only", 33);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxfile_stat_link(void *lxfile)
{
    LINE_EEER(lxfile(lxfile)->link_e);

    PUSH_DATA("cannot allocate memory", 22);

    POST_EEER();

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxfile_stat_lose(void *lxfile)
{
    int error;

    error = errno;

    LINE_EEER(lxfile(lxfile)->link_e);

    PUSH_DATA("cannot close file: ", 19);
    PUSH_TEXT(strerror(error));

    POST_EEER();

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxfile_stat_love(void *lxfile)
{
    LINE_EEER(lxfile(lxfile)->link_e);

    PUSH_DATA("cannot write: file not open", 27);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxfile_stat_miss(void *lxfile)
{
    LINE_EEER(lxfile(lxfile)->link_e);

    PUSH_DATA("cannot seek: file not open", 26);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxfile_stat_mode(void *lxfile)
{
    LINE_EEER(lxfile(lxfile)->link_e);

    PUSH_DATA("cannot reallocate memory", 24);

    POST_EEER();

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxfile_stat_node(void *lxfile)
{
    LINE_EEER(lxfile(lxfile)->link_e);

    PUSH_DATA("cannot read: file open write-only", 33);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxfile_stat_none(void *lxfile, const char *path)
{
    LINE_EEER(lxfile(lxfile)->link_e);

    PUSH_DATA("will not open `", 15);
    PUSH_TEXT(path);
    PUSH_DATA("' for neither read nor write access was requested", 49);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxfile_stat_null(void *lxfile)
{
    LINE_EEER(lxfile(lxfile)->link_e);

    PUSH_DATA("cannot read: file not open", 26);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxfile_stat_open(void *lxfile, const char *path)
{
    int error;

    error = errno;

    LINE_EEER(lxfile(lxfile)->link_e);

    PUSH_DATA("cannot open `", 13);
    PUSH_TEXT(path);
    PUSH_DATA("': ", 3);
    PUSH_TEXT(strerror(error));

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxfile_stat_peep(void *lxfile, long peep)
{
    LINE_EEER(lxfile(lxfile)->link_e);

    PUSH_DATA("out of range cache buffer access (", 34);
    PUSH_LONG(peep);
    PUSH_DATA(")", 1);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


#if 0
int
_libx1f4i0_lxfile_stat_pipe(void *lxfile, const char *path)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = lxfile(lxfile)->link_e.data;

	line = lxfile(lxfile)->link_e.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = lxfile(lxfile)->link_e.push;
	if (push) {
	    status = push(data, "will not open `", 15);
	    if (status) {
		break;
	    } else {
		status = push(data, path, strlen(path));
		if (status) {
		    break;
		} else {
		    status = push
			(data, "' for read/write access is not yet supported",
			 44);
		    if (status) {
			break;
		    }
		}
	    }
	}

	post = lxfile(lxfile)->link_e.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}
#endif				/* 0 */


int
_libx1f4i0_lxfile_stat_push(void *lxfile)
{
    int error;

    error = errno;

    LINE_EEER(lxfile(lxfile)->link_e);

    PUSH_DATA("cannot write file: ", 19);
    PUSH_TEXT(strerror(error));

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxfile_stat_rate(void *lxfile, long read)
{
    LINE_EEER(lxfile(lxfile)->link_e);

    PUSH_DATA("negative read request (", 23);
    PUSH_LONG(read);
    PUSH_DATA(")", 1);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxfile_stat_read(void *lxfile)
{
    int error;

    error = errno;

    LINE_EEER(lxfile(lxfile)->link_e);

    PUSH_DATA("cannot read file: ", 18);
    PUSH_TEXT(strerror(error));

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxfile_stat_seek(void *lxfile)
{
    int error;

    error = errno;

    LINE_EEER(lxfile(lxfile)->link_e);

    PUSH_DATA("cannot seek file: ", 18);
    PUSH_TEXT(strerror(error));

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxfile_stat_skip(void *lxfile, long skip)
{
    LINE_EEER(lxfile(lxfile)->link_e);

    PUSH_DATA("negative skip request (", 23);
    PUSH_LONG(skip);
    PUSH_DATA(")", 1);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxfile_stat_zero(void *lxfile)
{
    LINE_EEER(lxfile(lxfile)->link_e);

    PUSH_DATA("cannot write file", 17);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}
