/*
 * lxfile-a.c.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxfile-inter.h>
#include <lxfile-types.h>

#define exfile(file) \
    ((struct exfile_type *) (file)->socket)

int
_libx1f4i0_lxfile_side_file(void *subtext, void *file)
{
    int status;
    struct dxfile_type *dxfile_data;

    dxfile_data = file;
    if (!dxfile_data) {
	/*
	 * dxfile_data may well be null... - test may not be removed.
	 */

	status = 0;
    } else {
	int excess, (*free) (void *, void *);
	void *data, *file;

	data = ((struct lxfile_type *) subtext)->link_m.data;
	free = ((struct lxfile_type *) subtext)->link_m.free;

	file = dxfile_data->file;

	if (file) {
	    status = exfile(dxfile_data)->lose(file);
	    if (status) {
		status = _libx1f4i0_lxfile_stat_file(subtext, status);
	    }

	    excess = free(data, file);
	    if (excess) {
		excess = _libx1f4i0_lxfile_stat_free(subtext);
		if (status) {
		} else {
		    status = excess;
		}
	    }
	} else {
	    status = 0;
	}

	excess = free(data, dxfile_data);
	if (excess) {
	    excess = _libx1f4i0_lxfile_stat_free(subtext);
	    if (status) {
	    } else {
		status = excess;
	    }
	}
    }

    return status;
}
