/*
 * lxfile-a.a.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <unistd.h>

#include <sys/types.h>

#include <e4.h>
#include <file.h>
#include <lxfile-defs.h>
#include <variable.h>

#define READ_BUFFER			0

typedef struct constant_type {
    struct x1f4_variable_type variable;
    const void *data;
} constant_type;

static const X1f4_E4_C_MODE modes[] = {
/* *INDENT-OFF* */
    OPEN_APPEND,
    OPEN_CREATE,
    OPEN_NONBLOCKING,
    OPEN_READONLY,
    0,
    OPEN_TRUNCATE,
    OPEN_WRITEONLY
/* *INDENT-ON* */
};
static X1f4_E4_C_MODE names[] = {
/* *INDENT-OFF* */
    READ_BUFFER,
    FILE_ZERO_NEWS
/* *INDENT-ON* */
};
static const X1f4_E4_C_MODE seeks[] = {
/* *INDENT-OFF* */
    SEEK_CUR,
    SEEK_END,
    SEEK_SET
/* *INDENT-ON* */
};
static const struct constant_type constants[] = {
/* *INDENT-OFF* */
    {	{	"NEWS_SIGN",		X1f4_E4_MODE,
		X1f4_E4_READ_ONLY,	9			},
	names + 1							},
    {	{	"OPEN_APPEND",		X1f4_E4_MODE,
		X1f4_E4_READ_ONLY,	11			},
	modes + 0							},

    {	{	"OPEN_CREATE",		X1f4_E4_MODE,
		X1f4_E4_READ_ONLY,	11			},
	modes + 1							},

    {	{	"OPEN_NONBLOCKING",	X1f4_E4_MODE,
		X1f4_E4_READ_ONLY,	16			},
	modes + 2							},

    {	{	"OPEN_READONLY",	X1f4_E4_MODE,
		X1f4_E4_READ_ONLY,	13			},
	modes + 3							},

    {	{	"OPEN_TRUNCATE",	X1f4_E4_MODE,
		X1f4_E4_READ_ONLY,	13			},
	modes + 5							},

    {	{	"OPEN_WRITEONLY",	X1f4_E4_MODE,
		X1f4_E4_READ_ONLY,	14			},
	modes + 6							},

    {	{	"READ_BUFFER",		X1f4_E4_MODE,
		X1f4_E4_READ_ONLY,	11			},
	names + 0							},

    {	{	"SEEK_CURRENT",		X1f4_E4_MODE,
		X1f4_E4_READ_ONLY,	12			},
	seeks + 0							},

    {	{	"SEEK_END",		X1f4_E4_MODE,
		X1f4_E4_READ_ONLY,	8			},
	seeks + 1							},

    {	{	"SEEK_SET",		X1f4_E4_MODE,
		X1f4_E4_READ_ONLY,	8			},
	seeks + 2							}
/* *INDENT-ON* */
};

int
x1f4_vset_lxfile(void *lxfile, void **context)
{
    int status;
    const struct constant_type *constant_data;
    unsigned i, mind;

    constant_data = constants;

    _libx1f4i0_mind_ifile(&mind);

    names[0] = mind;

    i = sizeof(constants) / sizeof(struct constant_type);
    for (; i; i--) {
	status = x1f4_push_variable
	    (context, constant_data->variable.name,
	     constant_data->variable.length, constant_data->variable.type,
	     constant_data->variable.flags, (void *) constant_data->data);
	if (status) {
	    break;
	} else {
	    constant_data++;
	}
    }

    return status;
}
