/*
 * lxdecq-t.t.c
 * Copyright (C) 2008-2010, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <e4.h>
#include <f_list.h>
#include <lxcall.h>
#include <lxdecq-inter.h>
#include <lxdecq-types.h>

#define I_LIST(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define byte(miss)			((unsigned char *) (miss))

#define lxtext(delete)			((struct lxtext_type *) (delete))

int
_libx1f4i0_lxdecq_t_class_t(void *context, void *output, void **input)
{
    int status;
    struct dxlist_type *dxlist_data;
    struct lxdecq_type *lxdecq_data;

    lxdecq_data = lxtext(context)->text;

    dxlist_data = I_LIST(input[0]);
    if (0) {
    } else {
	if (!dxlist_data->size) {
	    status = _libx1f4i0_lxdecq_stat_null(lxdecq_data);
	} else {
	    void *data;

	    status = _libx1f4i0_ever_dllist(dxlist_data->list, &data);
	    if (status) {
		status = _libx1f4i0_lxdecq_stat_list(lxdecq_data, status);
	    } else {
		unsigned type;

		type = byte(data)[0] << 030 | byte(data)[1] << 020
		    | byte(data)[2] << 010 | byte(data)[3];
		if (type != X1f4_E4_TEXT) {
		    struct lxtext_type *lxtext_data;

		    lxtext_data = context;

		    status = _libx1f4i0_lxdecq_stat_type
			(lxdecq_data, dxlist_data->size - 1, type,
			 lxtext_data->lxtype.code);
		} else {
		    const char *lift;

		    lift = I_TEXT(byte(data) + 8);
		    status = _libx1f4i0_lxcall_part_text
			(&lxdecq_data->link_v, &lxdecq_data->link_e, lift,
			 strlen(lift), output);
		}
	    }
	}
    }

    return status;
}
