/*
 * lxdecq-f.s.c
 * Copyright (C) 2008-2010, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <lxcall.h>
#include <lxdecq-inter.h>
#include <lxdecq-types.h>

#define I_LIST(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_LIST(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

int
_libx1f4i0_lxdecq_s_forward(void *context, void *output, void **input)
{
    int status;
    struct dxlist_type *dxlist_text;
    struct lxdecq_type *lxdecq_data;

    dxlist_text = I_LIST(input[1]);

    lxdecq_data = context;

    status = _libx1f4i0_lxcall_near_node
	(&lxdecq_data->link_v, &lxdecq_data->link_e,
	 lxdecq_data->link_t.datatype, I_LIST(input[0]));
    if (status) {
    } else {
	lock_exlist(dxlist_text)->call++;

	l_LIST(dxlist_text, input[0]);
	l_LIST(dxlist_text, output);
    }

    return status;
}
