/*
 * lxdecq-f.f.c
 * Copyright (C) 2008-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <f_list.h>
#include <lxcall.h>
#include <lxdecq-inter.h>
#include <lxdecq-types.h>

#define I_LIST(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_USER(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxdecq_f_forward(void *context, void *output, void **input)
{
    int status;

    do {
	struct dxlist_type *dxlist_data;
	struct lxtext_type *lxtext_data;
	unsigned type;
	void *data;

	lxtext_data = context;

	dxlist_data = I_LIST(input[0]);

	type = lxtext_data->lxtype.code;

	status = _libx1f4i0_head_dllist(dxlist_data->list, &data);
	if (status) {
	    status = _libx1f4i0_lxdecq_stat_list(lxtext_data->text, status);
	} else {
	    unsigned link;
	    void *post;

	    byte(data)[0] = type >> 030;
	    byte(data)[1] = type >> 020;
	    byte(data)[2] = type >> 010;
	    byte(data)[3] = type >> 000;

	    status = lxtext_data->lxtype.post
		(lxtext_data->lxtype.context, &post,
		 lock_excase(dxlist_data));
	    if (status) {
		if (_libx1f4i0_mind_dllist(dxlist_data->list)) {
		    link = ~0;
		} else {
		    break;
		}
	    } else {
		struct lxdecq_type *lxdecq_data;

		lxdecq_data = lxtext_data->text;

		l_USER(post, byte(data) + 8);

		dxlist_data->size++;

		link = lxtext_data
		    - ((struct lxtext_type *) lxdecq_data->link_f.text);

		if (lxtext_data->lxtype.lead) {
		    status = _libx1f4i0_lxcall_pick_node
			(&lxdecq_data->link_v, &lxdecq_data->link_e,
			 &lxtext_data->lxtype, post, output);
		} else {
		    l_USER(post, output);
		}
	    }

	    byte(data)[4] = link >> 030;
	    byte(data)[5] = link >> 020;
	    byte(data)[6] = link >> 010;
	    byte(data)[7] = link >> 000;
	}
    } while (0);

    return status;
}
