/*
 * lxdecq-a.u.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <cl.h>
#include <copy.h>
#include <e4.h>
#include <lxdecq-inter.h>
#include <lxdecq-types.h>
#include <lxlead.h>

#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define club(miss)			((unsigned *) (miss))

#define byte(miss)			((unsigned char *) (miss))

#define becca(context) \
    ((void **) (context))
#define scope(context) \
    (becca((context)) + 2)
#define track(context) \
    (becca((context)) + 3)
#define frame(context) \
    (becca((context)) + 4)
#define class(context) \
    (becca((context)) + 5)

#define lxdecq(list) \
    ((struct lxdecq_type *) (list))

int
_libx1f4i0_lxdecq_copy_link(void *context, void *list, const void *data)
{
    int status;
    unsigned link;

    link = byte(data)[4] << 030 | byte(data)[5] << 020 | byte(data)[6] << 010
	| byte(data)[7];

#if SIZEOF_UNSIGNED == 4
    club(list)[0] = club(data)[0];
    club(list)[1] = club(data)[1];
#else
    byte(list)[0] = byte(data)[0];
    byte(list)[1] = byte(data)[1];
    byte(list)[2] = byte(data)[2];
    byte(list)[3] = byte(data)[3];
    byte(list)[4] = byte(data)[4];
    byte(list)[5] = byte(data)[5];
    byte(list)[6] = byte(data)[6];
    byte(list)[7] = byte(data)[7];
#endif				/* SIZEOF_UNSIGNED == 4 */

    do {
	list = byte(list) + 8;

	if (~link) {
	    struct lxtext_type *lxtext_link;

	    lxtext_link =
		((struct lxtext_type *) lxdecq(*becca(context))->link_f.text)
		+ link;

	    if (x1f4_pull_lxlead
		(*track(context), list, byte(data) + 8, &status,
		 *frame(context),
		 (struct x1f4_caselink_type **) class(context),
		 &lxtext_link->lxtype, lock_excase(*scope(context)))) {
		break;
	    }
	}

	{
	    unsigned type;

	    status = 0;

	    type = byte(data)[0] << 030 | byte(data)[1] << 020
		| byte(data)[2] << 010 | byte(data)[3];

	    copy_miss(list, type, byte(data) + 8);
	}
    } while (0);

    return status;

}
