/*
 * lxdecq-a.s.c
 * Copyright (C) 2008-2010, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxdecq-config.h>

#include <f_list.h>
#include <lxdecq-defs.h>
#include <lxdecq-inter.h>
#include <lxdecq-types.h>

int
_libx1f4i0_lxdecq_fast_list(void *lxdecq, void *dxlist)
{
    int status;
    struct lxdecq_type *lxdecq_data;
    struct x1f4_dllist_type dllist;
#if __TRANS_DECQ_LX_DEFINITION__
#else
    struct x1f4_trans_type redtext;
#endif				/* __TRANS_DECQ_LX_DEFINITION__ */

    lxdecq_data = lxdecq;

#if __TRANS_DECQ_LX_DEFINITION__
#else
    redtext.context = lxdecq_data->link_m.data;
#endif				/* __TRANS_DECQ_LX_DEFINITION__ */

#if __TRANS_DECQ_LX_DEFINITION__
#else
    redtext.free = lxdecq_data->link_m.free;
    redtext.link = lxdecq_data->link_m.link;
    redtext.mode = lxdecq_data->link_m.mode;
#endif				/* __TRANS_DECQ_LX_DEFINITION__ */

#if __TRANS_DECQ_LX_DEFINITION__
    dllist.trans = &lxdecq_data->link_m;
#else
    dllist.trans = &redtext;
#endif				/* __TRANS_DECQ_LX_DEFINITION__ */

    dllist.item = sizeof(struct fxdata_type) + 8;

    dllist.node = dllist.item << NODE_SHIFT;

    ((struct dxlist_type *) dxlist)->list = post_dxlist(dxlist);

    status = _libx1f4i0_fast_dllist
	(((struct dxlist_type *) dxlist)->list, X1f4_DLLIST_TRANS_MASK,
	 &dllist);
    if (status) {
	status = _libx1f4i0_lxdecq_stat_list(lxdecq_data, status);
    }

    return status;
}
