/*
 * lxdecq-a.l.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <f_list.h>
#include <lxcall.h>
#include <lxdecq-inter.h>
#include <lxdecq-types.h>
#include <lxlead.h>

#define dxlist(list) \
    ((struct dxlist_type *) (list))
#define lxdecq(list) \
    ((struct lxdecq_type *) (list))

#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define byte(miss)			((unsigned char *) (miss))

int
_libx1f4i0_lxdecq_null_list(void *lxdecq,
			    struct excase_type **excase, void *dxlist)
{
    int status = 0;
    unsigned size;

    size = dxlist(dxlist)->size;
    if (size) {
	int excess;
	struct excase_type *excase_data;
	struct lxtext_type *lxtext_data;
	void *list;

	lxtext_data = lxdecq(lxdecq)->link_f.text;

	if (excase) {
	    excase_data = *excase;
	} else {
	    excase_data = NULL;
	}

	list = dxlist(dxlist)->list;
	while (size) {
	    unsigned link;
	    void *data;

	    size--;

	    _libx1f4i0_lead_dllist(list, &data);

	    link = byte(data)[4] << 030 | byte(data)[5] << 020
		| byte(data)[6] << 010 | byte(data)[7];
	    if (~link) {
		int (*free) (void *, void *, struct excase_type **,
			     const struct excase_type *);
		struct lxtext_type *lxtext_link;

		lxtext_link = lxtext_data + link;

		if (lxtext_link->lxtype.flags & X1f4_LX_PICK_ACCESS) {
		    free = lxtext_link->lxtype.pick;
		} else {
		    free = lxtext_link->lxtype.free;
		}
		if (free) {
		    excess = free
			(lxtext_link->lxtype.context,
			 I_USER(byte(data) + 8), &excase_data,
			 lock_excase(dxlist));
		    if (excess) {
			if (status) {
			} else {
			    status = excess;
			}
		    }
		}
	    }

	    if (1) {
		excess = _libx1f4i0_mind_dllist(list);
		if (excess) {
		    excess = _libx1f4i0_lxdecq_stat_list(lxdecq, excess);
		    if (status) {
		    } else {
			status = excess;
		    }
		}
	    }
	}

	if (excase) {
	    *excase = excase_data;
	} else {
	    if (excase_data) {
		excess = x1f4_fail_lxlead(excase_data);
		if (excess) {
		    status = _libx1f4i0_lxcall_land_slip(excess, status);
		}
	    }
	}

	dxlist(dxlist)->size = size;
    }

    return status;
}
