/*
 * lxdecq-a.g.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxdecq-config.h>

#include <stddef.h>

#include <f_list.h>
#include <lxdecq-defs.h>
#include <lxdecq-inter.h>
#include <lxdecq-types.h>
#include <tcvset.h>

int
x1f4_line_lxdecq(void *subtext, void **address)
{
    int status;
    struct lxdecq_type *lxdecq_data;
    unsigned call;
    void *dxlist;

    lxdecq_data = subtext;

    _libx1f4i0_call_dllist(&call);

    status = lxdecq_data->link_m.link
	(lxdecq_data->link_m.data, &dxlist,
	 __struct_dxlist_type_alloc_size__ + call);
    if (status) {
	status = _libx1f4i0_lxdecq_stat_link(lxdecq_data);
    } else {
	dxlist = pick_dxlist(dxlist);

	status = _libx1f4i0_lxdecq_fast_list(subtext, dxlist);
	if (status) {
	    lxdecq_data->link_m.free
		(lxdecq_data->link_m.data, lock_cxlist(dxlist));
	} else {
	    ((struct dxlist_type *) dxlist)->size = 0;

	    lock_excase(dxlist)->nodetype_data = lxdecq_data->link_n.node;

	    lock_excase(dxlist)->slip = NULL;

	    lock_exlist(dxlist)->call = 1;

	    _libx1f4i0_init_tcvset
		(&lock_exlist(dxlist)->pset, &lock_exlist(dxlist)->text);

	    *address = dxlist;
	}
    }

    return status;
}
