/*
 * lxdecq-a.f.c
 * Copyright (C) 2008-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <lxlead.h>
#include <lxdecq-inter.h>
#include <nt.h>

int
x1f4_type_lxdecq(struct lxtype_type *lxtype_data, int cdecq3)
{
    lxtype_data->code = cdecq3;
    lxtype_data->name = "decq";
    lxtype_data->size = 4;
    lxtype_data->flags =
	X1f4_LX_AUTO_RECORD | X1f4_LX_LINK_ACCESS | X1f4_LX_PICK_ACCESS
	| X1f4_LX_POST_ACCESS | X1f4_LX_PULL_ACCESS;

    lxtype_data->call = x1f4_call_lxlead;
    lxtype_data->copy = x1f4_copy_lxdecq;
    lxtype_data->dump = x1f4_dump_lxdecq;
    lxtype_data->free = x1f4_free_lxdecq;
    lxtype_data->hash = x1f4_hash_lxdecq;
    lxtype_data->lead = x1f4_lead_lxdecq;
    lxtype_data->miss = x1f4_near_lxlead;
    lxtype_data->move = x1f4_move_lxdecq;
    lxtype_data->node = x1f4_node_lxdecq;
    lxtype_data->pick = x1f4_pick_lxdecq;
    lxtype_data->post = x1f4_post_lxdecq;
    lxtype_data->pull = x1f4_pull_lxdecq;
    lxtype_data->push = x1f4_push_lxdecq;
    lxtype_data->slip = x1f4_slip_lxdecq;

    return 0;
}
