/*
 * lxdecq-a.e.c
 * Copyright (C) 2008-2010, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <er.h>
#include <exerrors.h>
#include <f_list.h>
#include <lxdecq-inter.h>
#include <lxdecq-types.h>

#define lxdecq(lxdecq) \
    ((struct lxdecq_type *) (lxdecq))

int
_libx1f4i0_lxdecq_stat_call(void *lxdecq, int mode, unsigned found,
			    unsigned expected, int error)
{
    int status;

    if (error == X1f4_DLLIST_CALL_ERROR) {
	status = _libx1f4i0_lxdecq_stat_type(lxdecq, mode, found, expected);
    } else {
	status = _libx1f4i0_lxdecq_stat_list(lxdecq, error);
    }

    return status;
}


int
_libx1f4i0_lxdecq_stat_free(void *lxdecq)
{
    LINE_EEER(lxdecq(lxdecq)->link_e);

    PUSH_DATA("cannot free memory", 18);

    POST_EEER();

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxdecq_stat_link(void *lxdecq)
{
    LINE_EEER(lxdecq(lxdecq)->link_e);

    PUSH_DATA("cannot allocate memory", 22);

    POST_EEER();

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxdecq_stat_list(void *lxdecq, int error)
{
    int status;

    if (error == X1f4_DLLIST_FREE_ERROR) {
	status = _libx1f4i0_lxdecq_stat_free(lxdecq);
    } else {
	if (error == X1f4_DLLIST_LINK_ERROR) {
	    status = _libx1f4i0_lxdecq_stat_link(lxdecq);
	} else {
	    if (error == X1f4_DLLIST_MODE_ERROR) {
		status = _libx1f4i0_lxdecq_stat_mode(lxdecq);
	    } else {
		if (error == X1f4_DLLIST_SIZE_ERROR) {
		    status = _libx1f4i0_lxdecq_stat_size(lxdecq);
		} else {
		    status = X1f4_EX_CRITICAL;
		}
	    }
	}
    }

    return status;
}


int
_libx1f4i0_lxdecq_stat_mode(void *lxdecq)
{
    LINE_EEER(lxdecq(lxdecq)->link_e);

    PUSH_DATA("cannot reallocate memory", 24);

    POST_EEER();

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxdecq_stat_null(void *lxdecq)
{
    LINE_EEER(lxdecq(lxdecq)->link_e);

    PUSH_DATA("empty list", 10);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxdecq_stat_size(void *lxdecq)
{
    LINE_EEER(lxdecq(lxdecq)->link_e);

    PUSH_DATA("list not empty", 14);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxdecq_stat_type(void *lxdecq, int mode, unsigned found,
			    unsigned expected)
{
    LINE_EEER(lxdecq(lxdecq)->link_e);

    PUSH_DATA("mismatched type (", 17);
    PUSH_TRAP(found, lxdecq(lxdecq));
    PUSH_DATA(" found, ", 8);
    PUSH_TRAP(expected, lxdecq(lxdecq));
    PUSH_DATA(" expected) for ", 15);
    PUSH_MODE(mode + 1);
    PUSH_RANK(mode);
    PUSH_DATA(" list element", 13);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}
