/*
 * lxdecq-a.b.c
 * Copyright (C) 2008-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxdecq-config.h>

#include <stddef.h>

#include <f_list.h>
#include <exerrors.h>
#include <lxdecq-defs.h>
#include <lxdecq-inter.h>
#include <lxdecq-types.h>
#include <lxfset.h>
#include <lxlead.h>
#include <tcvset.h>

#define dxlist(list) \
    ((struct dxlist_type *) (list))
#define lxdecq(list) \
    ((struct lxdecq_type *) (list))

#define tccase(vset) \
    ((struct x1f4_tccase_type *) (vset))

int
x1f4_copy_lxdecq(void *subtext, void *bppp, void **copy,
		 const void *list, const struct excase_type *excase_data)
{
    int status;
    struct lxdecq_type *lxdecq_data;
    unsigned call;
    void *dxlist;

    lxdecq_data = subtext;

    _libx1f4i0_call_dllist(&call);

    status = lxdecq_data->link_m.link
	(lxdecq_data->link_m.data, &dxlist,
	 __struct_dxlist_type_alloc_size__ + call);
    if (status) {
	status = _libx1f4i0_lxdecq_stat_link(lxdecq_data);
    } else {
	void *bqpp;

	do {
	    void *record;

	    if (bppp) {
		bqpp = bppp;
	    } else {
		status = x1f4_init_lxfset(&bqpp);
		if (status) {
		    status = _libx1f4i0_lxdecq_stat_link(lxdecq_data);
		    if (1) {
			break;
		    }
		}
	    }

	    status = x1f4_post_lxfset(bqpp, &list, &record);
	    if (status) {
		status = _libx1f4i0_lxdecq_stat_link(lxdecq_data);
		if (1) {
		    break;
		}
	    } else {
		void *pset;
		const void *text;

		dxlist = pick_dxlist(dxlist);

		{
		    {
			void **node;

			node = record;
			node[0] = (void *) list;
			node[1] = dxlist;
		    }
		}

		lock_excase(dxlist)->nodetype_data = lxdecq_data->link_n.node;

		lock_excase(dxlist)->slip = NULL;

		lock_exlist(dxlist)->call = 1;

		_libx1f4i0_init_tcvset(&pset, &text);

		status = tccase(text)->push
		    (&pset, &text, excase_data, (void *) &lxdecq_data->link_m);
		if (status) {
		    status = X1f4_EX_CRITICAL;

		    _libx1f4i0_fini_tcvset
			(&pset, &text, (void *) &lxdecq_data->link_m);
		} else {
		    void *becca[6];

		    lock_exlist(dxlist)->pset = pset;
		    lock_exlist(dxlist)->text = text;

		    becca[0] = subtext;
		    becca[1] = NULL;
		    becca[2] = dxlist;
		    becca[3] = bqpp;
		    becca[4] = &lxdecq_data->link_m;
		    becca[5] = NULL;

		    status = _libx1f4i0_lxdecq_fast_list(subtext, dxlist);
		    if (status) {
		    } else {
			status = _libx1f4i0_line_dllist
			    (dxlist(dxlist)->list, dxlist(list)->list,
			     _libx1f4i0_lxdecq_copy_link,
			     _libx1f4i0_lxdecq_free_link, becca);
			if (status) {
			    status = _libx1f4i0_lxdecq_stat_list
				(lxdecq_data, status);

			    _libx1f4i0_flat_dllist
				(((struct dxlist_type *) dxlist)->list);
			}
		    }
		    if (status) {
			x1f4_lose_lxlead(becca[5], &lxdecq_data->link_m);

			_libx1f4i0_fini_tcvset
			    (&pset, &text, (void *) &lxdecq_data->link_m);
		    } else {
			dxlist(dxlist)->size = dxlist(list)->size;

			status = x1f4_beta_lxlead
			    (bqpp, becca[5], &lxdecq_data->link_m);
			if (status) {
			    _libx1f4i0_lxdecq_side_list(lxdecq_data, dxlist);
			} else {
			    *copy = dxlist;
			}

			dxlist = NULL;
		    }
		}
	    }
	} while (0);

	if (bqpp) {
	    if (bppp) {
	    } else {
		int excess;

		excess = x1f4_fini_lxfset(&bqpp);
		if (excess) {
		    excess = _libx1f4i0_lxdecq_stat_free(lxdecq_data);

		    if (status) {
		    } else {
			status = excess;
		    }
		}
	    }
	}

	if (dxlist) {
	    lxdecq_data->link_m.free
		(lxdecq_data->link_m.data, lock_cxlist(dxlist));
	}
    }

    return status;
}
