/*
 * lxdecq-a.0.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * NOTES
 *
 *.no type generic interfaces (yet).  If/when added, they should account for
 * function pointers.
 */

#include <lxdecq-config.h>

#include <stddef.h>
#include <string.h>

#include <e4-m.0.h>
#include <e4.h>
#include <lxcall.h>
#include <lxdecq-defs.h>
#include <lxdecq-inter.h>
#include <lxdecq-types.h>

#define MAKE_SINGLE(a, b)		a

#define may_include(lxtype)		0

#define l_d_type_post			2

#define l_v_type_post			2

#define screen(screen) \
    ((struct screen_type *) (screen))

#define fb_size()			1

#define fm_size(none) \
    sizeof(struct lxmiss_type)

extern const struct x1f4_eelookup_type _x1f4_type_lookup;

static int init_list(struct lxdecq_type *, unsigned,
		     const struct screen_type *);
static int line_data(struct lxdecq_type *, unsigned,
		     const struct screen_type *, void *, void *, void **,
		     void **);
static int line_list(struct lxdecq_type *, unsigned,
		     const struct screen_type *);
static int line_sail(struct lxdecq_type *, const struct screen_type *,
		     struct lxtext_type *, const struct lxtype_type *);
static int line_text(struct lxdecq_type *, unsigned,
		     const struct screen_type *, void *, void **, void **);
static int link_list(struct lxdecq_type *, unsigned,
		     const struct screen_type *);
static int pick_miss(unsigned *, unsigned *, unsigned *, unsigned,
		     const struct screen_type *);

static void line_amix(v_case_args_____0);
static void line_cfix(u_case_args_____0);
static void line_cmap(u_case_args_____0);
static void line_cset(v_case_args_____0);
static void line_cway(u_case_args_____0);
static void line_dmix(v_case_args_____0);
static void line_fset(v_case_args_____0);
static void line_hmix(v_case_args_____0);
static void line_imix(v_case_args_____0);
static void line_lfix(u_case_args_____0);
static void line_nset(u_case_args_____0);
static void line_rmap(u_case_args_____0);
static void line_rset(u_case_args_____0);
static void line_sfix(u_case_args_____0);
static void line_smap(u_case_args_____0);
static void line_sset(u_case_args_____0);
static void line_tmix(v_case_args_____0);
static void line_uset(v_case_args_____0);
static void line_vmix(v_case_args_____0);
static void line_zset(v_case_args_____0);

static const char fq_setf[] = "q_set", *const side_f[] = {
/* *INDENT-OFF* */
    fq_setf
/* *INDENT-ON* */
};
static const struct line_type call_line[] = {
/* *INDENT-OFF* */
#define l_new_count			1
    {	{	"q_new",
		_libx1f4i0_lxdecq_n_forward,	X1f4_E4_VOID,
		NULL,				l_new_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE
		| X1f4_E4_TEXT_LINK,
						5		},
	line_nset,							}
#define l_new_reach			(0 + (l_new_count << 1))
/* *INDENT-ON* */
#define call_line_count			l_new_reach
}, ever_line[] = {
/* *INDENT-OFF* */
#define l_set_count			2
    {	{	fq_setf,
		_libx1f4i0_lxdecq_s_forward,	0,
		NULL,				l_set_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE
		| X1f4_E4_TEXT_LINK,
						5		},
	line_sset,							}
#define l_set_reach			(0 + (l_set_count << 1))
/* *INDENT-ON* */
#define ever_line_count			l_set_reach
}, slip_line[] = {
/* *INDENT-OFF* */
#define l_class_count			1
    {	{	"q_class",
		_libx1f4i0_lxdecq_c_derived,	X1f4_E4_VOID,
		NULL,				l_class_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						7		},
	line_cway,							},
#define l_class_reach			(0 + l_class_count)
#define l_clear_count			1
    {	{	"q_clear",
		_libx1f4i0_lxdecq_c_pending,	X1f4_E4_VOID,
		NULL,				l_clear_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						7		},
	line_cmap,							},
#define l_clear_reach			(l_class_reach + l_clear_count)
#define l_copy_count			2
    {	{	"q_copy",
		_libx1f4i0_lxdecq_c_logique,	X1f4_E4_VOID,
		NULL,				l_copy_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_cfix,							},
#define l_copy_reach			(l_clear_reach + l_copy_count)
#define l_length_count			1
    {	{	"q_length",
		_libx1f4i0_lxdecq_l_logique,	X1f4_E4_MODE,
		NULL,				l_length_count,
		0,
						8		},
	line_lfix,							},
#define l_length_reach			(l_copy_reach + l_length_count)
#define l_reel_count			1
    {	{	"q_reel",
		_libx1f4i0_lxdecq_r_pending,	X1f4_E4_VOID,
		NULL,				l_reel_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_rmap,							},
#define l_reel_reach			(l_length_reach + l_reel_count)
#define l_roll_count			1
    {	{	"q_roll",
		_libx1f4i0_lxdecq_r_forward,	X1f4_E4_VOID,
		NULL,				l_roll_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_rset,							},
#define l_roll_reach			(l_reel_reach + l_roll_count)
#define l_short_count			1
    {	{	"q_short",
		_libx1f4i0_lxdecq_s_pending,	X1f4_E4_VOID,
		NULL,				l_short_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						7		},
	line_smap,							},
#define l_short_reach			(l_roll_reach + l_short_count)
#define l_swap_count			2
    {	{	"q_swap",
		_libx1f4i0_lxdecq_s_logique,	X1f4_E4_VOID,
		NULL,				l_swap_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_sfix,							}
#define l_swap_reach			(l_short_reach + l_swap_count)
/* *INDENT-ON* */
#define slip_line_count			l_swap_reach
};
static const struct link_type cast_line[] = {
/* *INDENT-OFF* */
#define lb_q__count			1
    {	{	"qb_q_",
		NULL,				0,
		NULL,				lb_q__count,
		X1f4_E4_TEXT_LINK,		5		},
	line_tmix,							},
#define lb_q__reach			(0 + lb_q__count)
#define lf_q__count			1
    {	{	"qf_q_",
		NULL,				0,
		NULL,				lf_q__count,
		X1f4_E4_TEXT_LINK,		5		},
	line_hmix,							}
#define lf_q__reach			(lb_q__reach + lf_q__count)
/* *INDENT-ON* */
#define cast_line_count			lf_q__reach
}, fast_line[] = {
/* *INDENT-OFF* */
#define lb_e__count			2
    {	{	"qb_e_",
		NULL,				X1f4_E4_VOID,
		NULL,				lb_e__count,
		0,				5		},
	line_vmix,							},
#define lb_e__reach			(0 + lb_e__count)
#define lb_p__count			2
    {	{	"qb_p_",
		NULL,				X1f4_E4_VOID,
		NULL,				lb_p__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						5		},
	line_amix,							},
#define lb_p__reach			(lb_e__reach + lb_p__count)
#define lf_e__count			2
    {	{	"qf_e_",
		NULL,				X1f4_E4_VOID,
		NULL,				lf_e__count,
		0,				5		},
	line_dmix,							},
#define lf_e__reach			(lb_p__reach + lf_e__count)
#define lf_p__count			2
    {	{	"qf_p_",
		NULL,				X1f4_E4_VOID,
		NULL,				lf_p__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						5		},
	line_imix,							}
#define lf_p__reach			(lf_e__reach + lf_p__count)
/* *INDENT-ON* */
#define fast_line_count			lf_p__reach
}, long_line[] = {
/* *INDENT-OFF* */
#define l_c__count			2
    {	{	"qf_l_",
		_libx1f4i0_lxdecq_c_forward,	X1f4_E4_VOID,
		NULL,				l_c__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						5		},
	line_cset,							},
#define l_c__reach			(0 + l_c__count)
#define l_u__count			2
    {	{	"qb_l_",
		_libx1f4i0_lxdecq_u_forward,	X1f4_E4_VOID,
		NULL,				l_u__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						5		},
	line_uset,							}
#define l_u__reach			(l_c__reach + l_u__count)
/* *INDENT-ON* */
#define long_line_count			l_u__reach
}, spin_line[] = {
/* *INDENT-OFF* */
#define l_f__count			1
    {	{	"qf_n_",
		_libx1f4i0_lxdecq_f_forward,	0,
		NULL,				l_f__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						5		},
	line_fset,							},
#define l_f__reach			(0 + l_f__count)
#define l_z__count			1
    {	{	"qb_n_",
		_libx1f4i0_lxdecq_z_forward,	0,
		NULL,				l_z__count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						5		},
	line_zset,							}
#define l_z__reach			(l_f__reach + l_z__count)
/* *INDENT-ON* */
#define spin_line_count			l_z__reach
};
static const struct x1f4_operator_type side_o[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("=", " "),  NULL,		0400,
	0,			NULL,
	X1f4_E4_BACK_LINK | X1f4_E4_E2ND_LINK | X1f4_E4_LEFT_XSET,
				1,
	NULL,			NULL					}
/* *INDENT-ON* */
};

static int
init_list(struct lxdecq_type *lxdecq_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    int status;

    if (bits & AUTOLINK_LINK) {
	lxdecq_data->link_v.data = screen_data->link_v.data;
	lxdecq_data->link_v.free = screen_data->link_v.free;
	lxdecq_data->link_v.link = screen_data->link_v.link;
	lxdecq_data->link_v.mode = screen_data->link_v.mode;
	lxdecq_data->link_v.pick = screen_data->link_v.pick;
	lxdecq_data->link_v.slip = screen_data->link_v.slip;
    } else {
	bits &= ~EVERLINK_SLIP;

	lxdecq_data->link_v.data = NULL;
	lxdecq_data->link_v.free = NULL;
	lxdecq_data->link_v.link = NULL;
	lxdecq_data->link_v.mode = NULL;
	lxdecq_data->link_v.pick = NULL;
	lxdecq_data->link_v.slip = NULL;
    }

    if (bits & CODELINK_LINK) {
	lxdecq_data->link_w.data = screen_data->link_w.data;
	lxdecq_data->link_w.free = screen_data->link_w.free;
	lxdecq_data->link_w.link = screen_data->link_w.link;
	lxdecq_data->link_w.mode = screen_data->link_w.mode;
    } else {
	lxdecq_data->link_w.data = NULL;
	lxdecq_data->link_w.free = _x1f4_e4_free_data;
	lxdecq_data->link_w.link = _x1f4_e4_link_data;
	lxdecq_data->link_w.mode = _x1f4_e4_mode_data;
    }

    if (bits & EELOOKUP_LINK) {
	lxdecq_data->trap_e.eelookup_data = screen_data->trap_e.eelookup_data;
    } else {
	lxdecq_data->trap_e.eelookup_data = &_x1f4_type_lookup;
    }

    if (bits & MISSBAIL_LINK) {
	lxdecq_data->link_r.call = screen_data->link_r.call;
	lxdecq_data->link_r.fine = screen_data->link_r.fine;
	lxdecq_data->link_r.miss = screen_data->link_r.miss;
	lxdecq_data->link_r.text = screen_data->link_r.text;
    } else {
	lxdecq_data->link_r.call = NULL;
	lxdecq_data->link_r.fine = NULL;
	lxdecq_data->link_r.miss = NULL;
    }

    if (bits & RESOURCE_LINK) {
	lxdecq_data->link_m.data = screen_data->link_m.data;
	lxdecq_data->link_m.free = screen_data->link_m.free;
	lxdecq_data->link_m.link = screen_data->link_m.link;
	lxdecq_data->link_m.mode = screen_data->link_m.mode;
    } else {
	lxdecq_data->link_m.data = NULL;
	lxdecq_data->link_m.free = _x1f4_e4_free_data;
	lxdecq_data->link_m.link = _x1f4_e4_link_data;
	lxdecq_data->link_m.mode = _x1f4_e4_mode_data;
    }

    if (bits & TEXTFLAT_LINK) {
	lxdecq_data->link_e.data = screen_data->link_e.data;
	lxdecq_data->link_e.line = screen_data->link_e.line;
	lxdecq_data->link_e.post = screen_data->link_e.post;
	lxdecq_data->link_e.push = screen_data->link_e.push;
    } else {
	lxdecq_data->link_e.data = NULL;
	lxdecq_data->link_e.line = NULL;
	lxdecq_data->link_e.post = NULL;
	lxdecq_data->link_e.push = NULL;
    }

    status = link_list(lxdecq_data, bits, screen_data);

    return status;
}


static int
line_data(struct lxdecq_type *lxdecq_data, unsigned bits,
	  const struct screen_type *screen_data, void *data, void *text,
	  void **args, void **dana)
{
    struct lxtext_type *lxtext_data;
    const struct lxtype_type *lxtype_data;
    struct x1f4_linetext_type *linetext_data;
    unsigned i;

    lxtype_data = screen_data->link_t.data;

    linetext_data = data;
    lxtext_data = text;

    lxtext_data--;

    lxtype_data--;

    i = screen_data->link_t.miss;
    for (; i; i--) {
	unsigned flags;

	lxtext_data++;

	lxtype_data++;

	line_sail(lxdecq_data, screen_data, lxtext_data, lxtype_data);

	flags = lxtype_data->flags;

	if (flags & X1f4_LX_TYPE_EXCEPT) {
	    continue;
	}

	if (1) {
	    _libx1f4i0_lxcall_push_line
		(lxtext_data, bits, screen_data, &linetext_data, lxtype_data,
		 args, dana, sizeof(fast_line) / sizeof(struct link_type),
		 fast_line);
	}
	if (bits & AUTOLINK_LINK) {
	    _libx1f4i0_lxcall_push_line
		(lxtext_data, bits, screen_data, &linetext_data, lxtype_data,
		 args, dana, sizeof(cast_line) / sizeof(struct link_type),
		 cast_line);
	}

	if (flags & LINK_ACCESS) {
	    _libx1f4i0_lxcall_push_line
		(lxtext_data, bits, screen_data, &linetext_data, lxtype_data,
		 args, dana, sizeof(long_line) / sizeof(struct link_type),
		 long_line);
	}
	if (flags & POST_ACCESS && bits & AUTOLINK_LINK) {
	    _libx1f4i0_lxcall_push_line
		(lxtext_data, bits, screen_data, &linetext_data, lxtype_data,
		 args, dana, sizeof(spin_line) / sizeof(struct link_type),
		 spin_line);
	}
    }

    return 0;
}


static int
line_list(struct lxdecq_type *lxdecq_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    lxdecq_data->link_t.datatype[0].context = lxdecq_data;

    lxdecq_data->link_t.datatype[0].flat = _libx1f4i0_lxdecq_flat_list;
    lxdecq_data->link_t.datatype[0].lead = _libx1f4i0_lxdecq_lead_list;
    lxdecq_data->link_t.datatype[0].line = _libx1f4i0_lxdecq_line_list;
    lxdecq_data->link_t.datatype[0].link = _libx1f4i0_lxdecq_link_list;
    lxdecq_data->link_t.datatype[0].name = "decq";
    lxdecq_data->link_t.datatype[0].shut = _libx1f4i0_lxdecq_flat_list;
    lxdecq_data->link_t.datatype[0].slip = _libx1f4i0_lxdecq_slip_list;
    lxdecq_data->link_t.datatype[0].size = 4;
    lxdecq_data->link_t.datatype[0].type = screen_data->link_l.type;

    lxdecq_data->link_t.datatype[1].context = NULL;

    lxdecq_data->link_t.datatype[1].flat = NULL;
    lxdecq_data->link_t.datatype[1].lead = NULL;
    lxdecq_data->link_t.datatype[1].line = NULL;
    lxdecq_data->link_t.datatype[1].link = NULL;
    lxdecq_data->link_t.datatype[1].name = NULL;
    lxdecq_data->link_t.datatype[1].shut = NULL;
    lxdecq_data->link_t.datatype[1].slip = NULL;
    lxdecq_data->link_t.datatype[1].size = 0;
    lxdecq_data->link_t.datatype[1].type = 0;

    return 0;
}


static int
line_sail(struct lxdecq_type *lxdecq_data,
	  const struct screen_type *screen_data,
	  struct lxtext_type *lxtext_data,
	  const struct lxtype_type *lxtype_data)
{
    int code;

    code = lxtype_data->code;

    lxtext_data->lxtype = *lxtype_data;
    lxtext_data->text = lxdecq_data;

    if (code == screen_data->link_l.type) {
	lxdecq_data->link_n.node = &lxtext_data->lxtype;
    } else {
	if (code == X1f4_E4_TEXT) {
	    lxtext_data->lxtype.context = lxdecq_data;

	    lxtext_data->lxtype.copy = _libx1f4i0_lxdecq_copy_text;
	    lxtext_data->lxtype.free = _libx1f4i0_lxdecq_free_text;
	    lxtext_data->lxtype.move = NULL;
	    lxtext_data->lxtype.push = _libx1f4i0_lxdecq_push_text;
	}
    }

    return 0;
}


static int
line_text(struct lxdecq_type *lxdecq_data, unsigned bits,
	  const struct screen_type *screen_data, void *data, void **args,
	  void **dana)
{
    struct x1f4_linetext_type *linetext_data;

    linetext_data = data;

    if (1) {
	_libx1f4i0_lxcall_side_line
	    (lxdecq_data, bits, screen_data, linetext_data, args,
	     sizeof(slip_line) / sizeof(struct line_type), slip_line);
	linetext_data += sizeof(slip_line) / sizeof(struct line_type);
    }
    if (bits & RESETNEW_SLIP) {
	_libx1f4i0_lxcall_side_line
	    (lxdecq_data, bits, screen_data, linetext_data, args,
	     sizeof(call_line) / sizeof(struct line_type), call_line);
	linetext_data += sizeof(call_line) / sizeof(struct line_type);
    }
    if (bits & EVERLINK_SLIP) {
	_libx1f4i0_lxcall_side_line
	    (lxdecq_data, bits, screen_data, linetext_data, args,
	     sizeof(ever_line) / sizeof(struct line_type), ever_line);
	linetext_data += sizeof(ever_line) / sizeof(struct line_type);
    }
    if (1) {
	_libx1f4i0_lxcall_zero_line(linetext_data);
    }

    return 0;
}


static int
link_list(struct lxdecq_type *lxdecq_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    int status;
    unsigned args_class, args_count, line_class, line_count, main_class,
	main_count, miss;
    void *data;

    args_count = 0;
    line_count = 1;
    main_count = 0;

    pick_miss(&args_class, &line_class, &main_class, bits, screen_data);

    miss = screen_data->link_t.miss;

    {
	args_count += slip_line_count;
	line_count += sizeof(slip_line) / sizeof(struct line_type);
    }
    if (bits & RESETNEW_SLIP) {
	args_count += call_line_count;
	line_count += sizeof(call_line) / sizeof(struct line_type);
    }
    if (bits & EVERLINK_SLIP) {
	args_count += ever_line_count;
	line_count += sizeof(ever_line) / sizeof(struct line_type);
    }

    status = lxdecq_data->link_w.link
	(lxdecq_data->link_w.data, &data,
	 fm_size(away)
	 + (args_class + args_count) * sizeof(int)
	 + miss * sizeof(struct lxtext_type)
	 + (line_class + line_count) * sizeof(struct x1f4_linetext_type)
	 + (sizeof(struct tide_type) + sizeof(struct x1f4_operator_type *))
	 * fb_size() + sizeof(struct x1f4_operator_type *)
	 + main_class + main_count);
    if (status) {
	status = LINK_ERROR;
    } else {
	void *args, *dana, *side, *tile, *text;

	tile = (struct x1f4_linetext_type *) data + line_class;
	dana = (struct x1f4_linetext_type *) tile + line_count;
	text = (struct lxmiss_type *) dana + 1;
	side = (struct lxtext_type *) text + miss;
	side = (struct tide_type *) side + fb_size();
	args = (struct x1f4_operator_type **) side + fb_size() + 1;
	dana = (int *) args + args_class + args_count;

	lxdecq_data->link_f.data = data;
	lxdecq_data->link_f.side = side;
	lxdecq_data->link_f.text = text;

	((struct lxmiss_type *) text - 1)->data.miss = miss;

	line_data(lxdecq_data, bits, screen_data, data, text, &args, &dana);
	line_text(lxdecq_data, bits, screen_data, tile, &args, &dana);
	_libx1f4i0_lxcall_line_side(side, data, side_o, side_f, fb_size());

	line_list(lxdecq_data, bits, screen_data);
    }

    return status;
}


static int
pick_miss(unsigned *args, unsigned *line, unsigned *pick, unsigned bits,
	  const struct screen_type *screen_data)
{
    const struct lxtype_type *lxtype_data;
    unsigned args_count = 0, line_count = 0, i, main_count = 0;

    lxtype_data = screen_data->link_t.data;
    lxtype_data--;

    i = screen_data->link_t.miss;
    for (; i; i--) {
	unsigned deck, flags;

	lxtype_data++;

	flags = lxtype_data->flags;

	if (flags & X1f4_LX_TYPE_EXCEPT) {
	    continue;
	}

	deck = 5 + lxtype_data->size + 1;

	if (1) {
	    args_count += fast_line_count;
	    line_count += sizeof(fast_line) / sizeof(struct link_type);
	    main_count += deck * sizeof(fast_line) / sizeof(struct link_type);
	}
	if (bits & AUTOLINK_LINK) {
	    args_count += cast_line_count;
	    line_count += sizeof(cast_line) / sizeof(struct link_type);
	    main_count += deck * sizeof(cast_line) / sizeof(struct link_type);
	}

	if (flags & FLAT_REFLEX) {
	} else {
	    args_count += l_d_type_post;
	    args_count += l_v_type_post;
	}
	if (flags & LINK_ACCESS) {
	    args_count += long_line_count;
	    line_count += sizeof(long_line) / sizeof(struct link_type);
	    main_count += deck * sizeof(long_line) / sizeof(struct link_type);
	}
	if (flags & POST_ACCESS && bits & AUTOLINK_LINK) {
	    args_count += spin_line_count;
	    line_count += sizeof(spin_line) / sizeof(struct link_type);
	    main_count += deck * sizeof(spin_line) / sizeof(struct link_type);
	}
    }

    *args = args_count;
    *line = line_count;
    *pick = main_count;

    return 0;
}


static void
line_amix(v_case_args_____1)
{
    int *line, type;

    line = *args;

    linetext_data->function.args = line;

    type = nodetype_data->code;

    *line++ = screen(screen)->link_l.type;
    *line++ = type;

    *args = line;

    if (nodetype_data->copy || may_include(lxtype_data)) {
	linetext_data->function.function = _libx1f4i0_lxdecq_a_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxdecq_a_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxdecq_a_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxdecq_a_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxdecq_a_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxdecq_a_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }
}


static void
line_cfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_cmap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_cset(v_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = nodetype_data->code;

    *args = line;
}


static void
line_cway(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_dmix(v_case_args_____1)
{
    int *line, type;
    unsigned flags;

    flags = nodetype_data->flags;

    line = *args;

    linetext_data->function.args = line;

    type = nodetype_data->code;

    *line++ = type;
    *line++ = screen(screen)->link_l.type;
    if (flags & FLAT_REFLEX) {
    } else {
	*line++ = X1f4_E4_POST_XSET;
	*line++ = 0;
    }

    *args = line;

    if (flags & FLAT_REFLEX) {
	linetext_data->function.flags = X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK;
    } else {
	linetext_data->function.flags =
	    X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE | X1f4_E4_TEXT_LINK;
    }

    if (nodetype_data->push) {
	linetext_data->function.function = _libx1f4i0_lxdecq_d_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxdecq_d_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxdecq_d_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxdecq_d_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxdecq_d_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxdecq_d_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }
}


static void
line_fset(v_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;

    linetext_data->function.type = nodetype_data->code;
}


static void
line_hmix(v_case_args_____1)
{
    int *line, type;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;

    type = nodetype_data->code;

    if (nodetype_data->lead) {
	linetext_data->function.function = _libx1f4i0_lxdecq_h_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxdecq_h_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxdecq_h_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxdecq_h_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxdecq_h_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxdecq_h_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }

    linetext_data->function.type = type;
}


static void
line_imix(v_case_args_____1)
{
    int *line, type;

    line = *args;

    linetext_data->function.args = line;

    type = nodetype_data->code;

    *line++ = screen(screen)->link_l.type;
    *line++ = type;

    *args = line;

    if (nodetype_data->copy || may_include(lxtype_data)) {
	linetext_data->function.function = _libx1f4i0_lxdecq_i_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxdecq_i_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxdecq_i_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxdecq_i_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxdecq_i_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxdecq_i_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }
}


static void
line_lfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_nset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_POST_XSET;

    *args = line;
}


static void
line_rmap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_rset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_sfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_smap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_sset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_POST_XSET;
    *line++ = 0;

    *args = line;

    linetext_data->function.type = screen(screen)->link_l.type;
}


static void
line_tmix(v_case_args_____1)
{
    int *line, type;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;

    type = nodetype_data->code;

    if (nodetype_data->lead) {
	linetext_data->function.function = _libx1f4i0_lxdecq_t_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxdecq_t_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxdecq_t_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxdecq_t_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxdecq_t_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxdecq_t_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }

    linetext_data->function.type = type;
}


static void
line_uset(v_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = nodetype_data->code;

    *args = line;
}


static void
line_vmix(v_case_args_____1)
{
    int *line, type;
    unsigned flags;

    flags = nodetype_data->flags;

    line = *args;

    linetext_data->function.args = line;

    type = nodetype_data->code;

    *line++ = type;
    *line++ = screen(screen)->link_l.type;
    if (flags & FLAT_REFLEX) {
    } else {
	*line++ = X1f4_E4_POST_XSET;
	*line++ = 0;
    }

    *args = line;

    if (flags & FLAT_REFLEX) {
	linetext_data->function.flags = X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK;
    } else {
	linetext_data->function.flags =
	    X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE | X1f4_E4_TEXT_LINK;
    }

    if (nodetype_data->push) {
	linetext_data->function.function = _libx1f4i0_lxdecq_v_class_v;
    } else {
	if (X1f4_E4_LAST < type) {
	    linetext_data->function.function = _libx1f4i0_lxdecq_v_class_u;
	} else {
	    if (type == X1f4_E4_TEXT) {
		linetext_data->function.function = _libx1f4i0_lxdecq_v_class_t;
	    } else {
		if (type == X1f4_E4_REAL) {
		    linetext_data->function.function =
			_libx1f4i0_lxdecq_v_class_r;
		} else {
		    if (type == X1f4_E4_MODE) {
			linetext_data->function.function =
			    _libx1f4i0_lxdecq_v_class_m;
		    } else {
			if (type == X1f4_E4_BILL) {
			    linetext_data->function.function =
				_libx1f4i0_lxdecq_v_class_b;
			} else {
			}
		    }
		}
	    }
	}
    }
}


static void
line_zset(v_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;

    linetext_data->function.type = nodetype_data->code;
}


int
x1f4_init_lxdecq(void **lxdecq, unsigned bits,
		 const struct screen_type *screen_data)
{
    int (*link) (void *, void **, unsigned), status;
    void *list, *text;

    if (bits & CODELINK_LINK) {
	link = screen_data->link_w.link;
	text = screen_data->link_w.data;
    } else {
	link = _x1f4_e4_link_data;
	text = (void *) 0;
    }

    status = link(text, &list, sizeof(struct lxdecq_type));
    if (status) {
	status = LINK_ERROR;
    } else {
	status = init_list(list, bits, screen_data);
	if (status) {
	    if (bits & CODELINK_LINK) {
		screen_data->link_w.free(text, list);
	    } else {
		_x1f4_e4_free_data(text, list);
	    }
	} else {
	    *lxdecq = list;
	}
    }

    return status;
}
