/*
 * lxdate-e.u.c
 * Copyright (C) 2008-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <lxdate-types.h>

#define I_DATE(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define dxdate(date) \
    ((struct dxdate_type *) (date))

static char *const week[] = {
/* *INDENT-OFF* */
    "Sun",
    "Mon",
    "Tue",
    "Wed",
    "Thu",
    "Fri",
    "Sat"
/* *INDENT-ON* */
};

int
_libx1f4i0_lxdate_3_pending(void *context, void *output, void **input)
{
    l_TEXT(week[dxdate(I_DATE(input[0]))->second_l & 7], output);

    return 0;
}
