/*
 * lxdate-l.r.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <time.h>

#include <e4.h>
#include <lxdate-break.h>
#include <lxdate-inter.h>
#include <lxdate-types.h>

#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_DATE(t)			(*((X1f4_E4_C_USER *) (t)))

#define b3(___b)			((___b) & 7)
#define b4(___b)			((___b) & 15)
#define b5(___b)			((___b) & 31)
#define b6(___b)			((___b) & 63)
#define b9(___b)			((___b) & 511)

int
_libx1f4i0_lxdate_r_logique(void *context, void *output, void **input)
{
    X1f4_E4_C_MODE window_a, window_f;
    int status;
    struct dxdate_type *dxdate_data;
    struct tm down_time;
    time_t second_a = 0;
    unsigned second_f = 0;

    dxdate_data = I_DATE(input[0]);

    down_time.tm_year = I_MODE(input[1]) - 1900;
    down_time.tm_mon = I_MODE(input[2]) - 1;
    down_time.tm_mday = I_MODE(input[3]);
    down_time.tm_hour = I_MODE(input[4]);
    down_time.tm_min = I_MODE(input[5]);

    window_a = I_MODE(input[6]);
    window_f = I_MODE(input[7]);

    date_break(second_a, second_f, window_a, window_f);

    down_time.tm_sec = second_a;

    down_time.tm_isdst = -1;

    second_a = mktime(&down_time);
    if (second_a == (time_t) -1) {
	status = _libx1f4i0_lxdate_stat_down(context);
    } else {
	status = 0;

	dxdate_data->time = second_a;
	dxdate_data->second_f = second_f;

	dxdate_data->second_i = b6(down_time.tm_sec)
	    | b6(down_time.tm_min) << 6 | b5(down_time.tm_hour) << 12
	    | b5(down_time.tm_mday) << 17 | b4(down_time.tm_mon) << 22;
	dxdate_data->second_l = b3(down_time.tm_wday)
	    | b9(down_time.tm_yday) << 3 | down_time.tm_year << 12;
    }

    return status;
}
