/*
 * lxdate-f.s.c
 * Copyright (C) 2008, 2009, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <lxcall.h>
#include <lxdate-inter.h>
#include <lxdate-types.h>

#define I_DATE(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_DATE(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define lock_exdate(date) \
    (date)

int
_libx1f4i0_lxdate_s_forward(void *context, void *output, void **input)
{
    int status;
    struct dxdate_type *dxdate_text;
    struct lxdate_type *lxdate_data;

    dxdate_text = I_DATE(input[1]);

    lxdate_data = context;

    status = _libx1f4i0_lxcall_near_node
	(&lxdate_data->link_v, &lxdate_data->link_e,
	 lxdate_data->link_t.datatype + 0, I_DATE(input[0]));
    if (status) {
    } else {
	lock_exdate(dxdate_text)->call++;

	l_DATE(dxdate_text, input[0]);
	l_DATE(dxdate_text, output);
    }

    return status;
}
