/*
 * lxdate-e.w.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxdate-inter.h>
#include <lxdate-types.h>

int
x1f4_slip_lxdate(void *subtext, void **data)
{
    int status;
    struct dxdate_type *dxdate_data;
    unsigned call;

    dxdate_data = *data;

    call = dxdate_data->call;
    call--;
    if (call) {
	dxdate_data->call = call;

	status = 0;
    } else {
	status = _libx1f4i0_lxdate_side_date(subtext, dxdate_data);
    }

    return status;
}
