/*
 * lxdate-a.0.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <e4-m.0.h>
#include <e4.h>
#include <lxcall.h>
#include <lxdate-defs.h>
#include <lxdate-inter.h>
#include <lxdate-types.h>

#define MAKE_SINGLE(a, b)		a

#define i_effect_args			1
#define i_effect_name			6

#define i_effect_size			fv_size(i_effect_args, i_effect_name)

#define i_eighth_args			1
#define i_eighth_name			13

#define i_eighth_size			fv_size(i_eighth_args, i_eighth_name)

#define i_second_args			1
#define i_second_name			8

#define i_second_size			fv_size(i_second_args, i_second_name)

#define i_time_0_args			1
#define i_time_0_name			10

#define i_time_0_size			fv_size(i_time_0_args, i_time_0_name)

#define i_time_1_args			1
#define i_time_1_name			10

#define i_time_1_size			fv_size(i_time_1_args, i_time_1_name)

#define i_time_2_args			1
#define i_time_2_name			8

#define i_time_2_size			fv_size(i_time_2_args, i_time_2_name)

#define i_time_d_args			1
#define i_time_d_name			5

#define i_time_d_size			fv_size(i_time_d_args, i_time_d_name)

#define i_time_f_args			1
#define i_time_f_name			9

#define i_time_f_size			fv_size(i_time_f_args, i_time_f_name)

#define i_reflex_args			4
#define i_reflex_name			5

#define l_date_0_args			1
#define l_date_0_name			10

#define l_date_0_size			fv_size(l_date_0_args, l_date_0_name)

#define l_date_1_args			1
#define l_date_1_name			10

#define l_date_1_size			fv_size(l_date_1_args, l_date_1_name)

#define l_date_2_args			1
#define l_date_2_name			8

#define l_date_2_size			fv_size(l_date_2_args, l_date_2_name)

#define l_date_3_args			1
#define l_date_3_name			7

#define l_date_3_size			fv_size(l_date_3_args, l_date_3_name)

#define l_date_4_args			1
#define l_date_4_name			7

#define l_date_4_size			fv_size(l_date_4_args, l_date_4_name)

#define l_date_5_args			1
#define l_date_5_name			7

#define l_date_5_size			fv_size(l_date_5_args, l_date_5_name)

#define l_date_6_args			1
#define l_date_6_name			9

#define l_date_6_size			fv_size(l_date_6_args, l_date_6_name)

#define l_date_7_args			1
#define l_date_7_name			6

#define l_date_7_size			fv_size(l_date_7_args, l_date_7_name)

#define l_mirror_args			2
#define l_mirror_name			6

#define l_mirror_size			fv_size(l_mirror_args, l_mirror_name)

#define l_reflex_args			4
#define l_reflex_name			5

#define l_week_3_args			1
#define l_week_3_name			7

#define l_week_3_size			fv_size(l_week_3_args, l_week_3_name)

#define l_week_n_args			1
#define l_week_n_name			7

#define l_week_n_size			fv_size(l_week_n_args, l_week_n_name)

#define l_year_3_args			1
#define l_year_3_name			9

#define l_year_3_size			fv_size(l_year_3_args, l_year_3_name)

#define l_year_n_args			1
#define l_year_n_name			9

#define l_year_n_size			fv_size(l_year_n_args, l_year_n_name)

#define l________size \
    sizeof(struct x1f4_linetext_type)

#define fb_size()			2

#define fl_line(none) \
    (i_effect_args							      \
     + i_eighth_args							      \
     + i_second_args							      \
     + i_time_0_args							      \
     + i_time_1_args							      \
     + i_time_2_args							      \
     + i_time_d_args							      \
     + i_time_f_args							      \
     + l_date_0_args							      \
     + l_date_1_args							      \
     + l_date_2_args							      \
     + l_date_3_args							      \
     + l_date_4_args							      \
     + l_date_5_args							      \
     + l_date_6_args							      \
     + l_date_7_args							      \
     + l_mirror_args							      \
     + l_week_3_args							      \
     + l_week_n_args							      \
     + l_year_3_args							      \
     + l_year_n_args)

#define fl_page(none) \
    22

#define fl_size(none) \
    (i_effect_size							      \
     + i_eighth_size							      \
     + i_second_size							      \
     + i_time_0_size							      \
     + i_time_1_size							      \
     + i_time_2_size							      \
     + i_time_d_size							      \
     + i_time_f_size							      \
     + l_date_0_size							      \
     + l_date_1_size							      \
     + l_date_2_size							      \
     + l_date_3_size							      \
     + l_date_4_size							      \
     + l_date_5_size							      \
     + l_date_6_size							      \
     + l_date_7_size							      \
     + l_mirror_size							      \
     + l_week_3_size							      \
     + l_week_n_size							      \
     + l_year_3_size							      \
     + l_year_n_size							      \
     + l________size)

#define screen(screen) \
    ((struct screen_type *) (screen))

#define fv_size(args, name) \
    (sizeof(struct x1f4_linetext_type) + sizeof(int) * (args))

#define q_case_args_____0 \
    struct lxdate_type *, const struct screen_type *,			      \
    struct x1f4_linetext_type *, void **, void **
#define q_case_args_____1 \
    struct lxdate_type *lxdate_data, const struct screen_type *screen_data,   \
    struct x1f4_linetext_type *linetext_data, void **args, void **dana
#define q_case_args_____2 \
    lxdate_data, screen_data, linetext_data, args, dana

static int init_date(struct lxdate_type *, unsigned,
		     const struct screen_type *);
static int line_0fix(q_case_args_____0);
static int line_0set(q_case_args_____0);
static int line_1fix(q_case_args_____0);
static int line_1set(q_case_args_____0);
static int line_2fix(q_case_args_____0);
static int line_2set(q_case_args_____0);
static int line_3fix(q_case_args_____0);
static int line_4fix(q_case_args_____0);
static int line_5fix(q_case_args_____0);
static int line_6fix(q_case_args_____0);
static int line_7fix(q_case_args_____0);
static int line_date(struct lxdate_type *, unsigned,
		     const struct screen_type *);
static int line_fset(q_case_args_____0);
static int line_mset(q_case_args_____0);
static int line_pfix(q_case_args_____0);
static int line_qfix(q_case_args_____0);
static int line_sset2(q_case_args_____0);
static int line_text(struct lxdate_type *, unsigned,
		     const struct screen_type *, void *, void **, void **);
static int line_ufix(q_case_args_____0);
static int line_vfix(q_case_args_____0);
static int line_xset(q_case_args_____0);
static int line_yset(q_case_args_____0);
static int link_date(struct lxdate_type *, unsigned,
		     const struct screen_type *);

static void line_afix(u_case_args_____0);
static void line_cfix(u_case_args_____0);
static void line_cset(u_case_args_____0);
static void line_ffix(u_case_args_____0);
static void line_fmap(u_case_args_____0);
static void line_mfix(u_case_args_____0);
static void line_nfix(u_case_args_____0);
static void line_nset(u_case_args_____0);
static void line_ofix(u_case_args_____0);
static void line_rfix(u_case_args_____0);
static void line_sfix(u_case_args_____0);
static void line_sset(u_case_args_____0);
static void list_cfix(u_case_args_____0);
static void list_cset(u_case_args_____0);
static void list_dfix(u_case_args_____0);
static void list_fmap(u_case_args_____0);
static void list_nset(u_case_args_____0);
static void list_sset(u_case_args_____0);

static const char fd_setf[] = "d_set", ft_setf[] = "t_set", *const side_f[] = {
/* *INDENT-OFF* */
    fd_setf,
    ft_setf
/* *INDENT-ON* */
};
static const struct line_type call_line[] = {
/* *INDENT-OFF* */
#define d_new_count			1
    {	{	"d_new",
		_libx1f4i0_lxdate_n_forward,	X1f4_E4_VOID,
		NULL,				d_new_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE
		| X1f4_E4_TEXT_LINK,
						5		},
	line_nset,							},
#define d_new_reach			(0 + (d_new_count << 1))
#define t_new_count			1
    {	{	"t_new",
		_libx1f4i0_lxtime_n_forward,	X1f4_E4_VOID,
		NULL,				t_new_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE
		| X1f4_E4_TEXT_LINK,
						5		},
	list_nset,							}
#define t_new_reach			(d_new_reach + (t_new_count << 1))
/* *INDENT-ON* */
#define call_line_count			t_new_reach
}, ever_line[] = {
/* *INDENT-OFF* */
#define d_set_count			2
    {	{	fd_setf,
		_libx1f4i0_lxdate_s_forward,	0,
		NULL,				d_set_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE
		| X1f4_E4_TEXT_LINK,
						5		},
	line_sset,							},
#define d_set_reach			(0 + (d_set_count << 1))
#define t_set_count			2
    {	{	ft_setf,
		_libx1f4i0_lxtime_s_forward,	0,
		NULL,				t_set_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE
		| X1f4_E4_TEXT_LINK,
						5		},
	list_sset,							}
#define t_set_reach			(d_set_reach + (t_set_count << 1))
/* *INDENT-ON* */
#define ever_line_count			t_set_reach
}, slip_line[] = {
/* *INDENT-OFF* */
#define d_add_count			2
    {	{	"d_add",
		_libx1f4i0_lxdate_a_logique,	X1f4_E4_VOID,
		NULL,				d_add_count,
		0,				5		},
	line_afix,							},
#define d_add_reach			(0 + d_add_count)
#define d_compare_count			2
    {	{	"d_compare",
		_libx1f4i0_lxdate_c_forward,	X1f4_E4_MODE,
		NULL,				d_compare_count,
		0,				9		},
	line_cset,							},
#define d_compare_reach			(d_add_reach + d_compare_count)
#define d_copy_count			2
    {	{	"d_copy",
		_libx1f4i0_lxdate_c_logique,	X1f4_E4_VOID,
		NULL,				d_copy_count,
		0,				6		},
	line_cfix,							},
#define d_copy_reach			(d_compare_reach + d_copy_count)
#define d_fix_count			3
    {	{	"d_fix",
		_libx1f4i0_lxdate_f_pending,	X1f4_E4_VOID,
		NULL,				d_fix_count,
		0,				5		},
	line_fmap,							},
#define d_fix_reach			(d_copy_reach + d_fix_count)
#define d_microsecond_count		1
    {	{	"d_microsecond",
		_libx1f4i0_lxdate_m_logique,	X1f4_E4_MODE,
		NULL,				d_microsecond_count,
		0,				13		},
	line_mfix,							},
#define d_microsecond_reach		(d_fix_reach + d_s_frame_count)
#define d_now_count			1
    {	{	"d_now",
		_libx1f4i0_lxdate_n_logique,	X1f4_E4_VOID,
		NULL,				d_now_count,
		X1f4_E4_KEEP_CALL,		5		},
	line_nfix,							},
#define d_now_reach			(d_microsecond_reach + d_now_count)
#define d_offset_count			3
    {	{	"d_offset",
		_libx1f4i0_lxdate_o_logique,	X1f4_E4_VOID,
		NULL,				d_offset_count,
		0,				8		},
	line_ofix,							},
#define d_offset_reach			(d_now_reach + d_offset_count)
#define d_resolve_count			8
    {	{	"d_resolve",
		_libx1f4i0_lxdate_r_logique,	X1f4_E4_VOID,
		NULL,				d_resolve_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						9		},
	line_rfix,							},
#define d_resolve_reach			(d_offset_reach + d_resolve_count)
#define d_s_frame_count			1
    {	{	"d_s_frame",
		_libx1f4i0_lxdate_f_logique,	X1f4_E4_MODE,
		NULL,				d_s_frame_count,
		0,				9		},
	line_ffix,							},
#define d_s_frame_reach			(d_resolve_reach + d_s_frame_count)
#define d_second_count			1
    {	{	"d_second",
		_libx1f4i0_lxdate_s_logique,	X1f4_E4_MODE,
		NULL,				d_second_count,
		0,				8		},
	line_sfix,							},
#define d_second_reach			(d_s_frame_reach + d_s_frame_count)
#define t_compare_count			2
    {	{	"t_compare",
		_libx1f4i0_lxtime_c_forward,	X1f4_E4_MODE,
		NULL,				t_compare_count,
		0,				9		},
	list_cset,							},
#define t_compare_reach			(d_second_reach + t_compare_count)
#define t_copy_count			2
    {	{	"t_copy",
		_libx1f4i0_lxtime_c_logique,	X1f4_E4_VOID,
		NULL,				t_copy_count,
		0,				6		},
	list_cfix,							},
#define t_copy_reach			(t_compare_reach + t_copy_count)
#define t_ddiff_count			3
    {	{	"t_ddiff",
		_libx1f4i0_lxtime_d_logique,	X1f4_E4_VOID,
		NULL,				t_ddiff_count,
		0,				7		},
	list_dfix,							},
#define t_ddiff_reach			(t_compare_reach + t_ddiff_count)
#define t_fix_count			3
    {	{	"t_fix",
		_libx1f4i0_lxtime_f_pending,	X1f4_E4_VOID,
		NULL,				t_fix_count,
		0,				5		},
	list_fmap,							}
#define t_fix_reach			(t_ddiff_reach + t_fix_count)
/* *INDENT-ON* */
#define slip_line_count			t_fix_reach
};
static const struct x1f4_operator_type side_o[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("=", " "),  NULL,		0400,
	0,			NULL,
	X1f4_E4_BACK_LINK | X1f4_E4_E2ND_LINK | X1f4_E4_LEFT_XSET,
				1,
	NULL,			NULL					},
    {	MAKE_SINGLE("=", " "),  NULL,		0400,
	0,			NULL,
	X1f4_E4_BACK_LINK | X1f4_E4_E2ND_LINK | X1f4_E4_LEFT_XSET,
				1,
	NULL,			NULL					}
/* *INDENT-ON* */
};

static int
init_date(struct lxdate_type *lxdate_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    int status;

    if (bits & AUTOLINK_LINK) {
	lxdate_data->link_v.data = screen_data->link_v.data;
	lxdate_data->link_v.free = screen_data->link_v.free;
	lxdate_data->link_v.link = screen_data->link_v.link;
	lxdate_data->link_v.mode = screen_data->link_v.mode;
	lxdate_data->link_v.pick = screen_data->link_v.pick;
	lxdate_data->link_v.slip = screen_data->link_v.slip;
    } else {
	bits &= ~EVERLINK_SLIP;

	lxdate_data->link_v.data = NULL;
	lxdate_data->link_v.free = NULL;
	lxdate_data->link_v.link = NULL;
	lxdate_data->link_v.mode = NULL;
	lxdate_data->link_v.pick = NULL;
	lxdate_data->link_v.slip = NULL;
    }

    if (bits & CODELINK_LINK) {
	lxdate_data->link_w.data = screen_data->link_w.data;
	lxdate_data->link_w.free = screen_data->link_w.free;
	lxdate_data->link_w.link = screen_data->link_w.link;
	lxdate_data->link_w.mode = screen_data->link_w.mode;
    } else {
	lxdate_data->link_w.data = NULL;
	lxdate_data->link_w.free = _x1f4_e4_free_data;
	lxdate_data->link_w.link = _x1f4_e4_link_data;
	lxdate_data->link_w.mode = _x1f4_e4_mode_data;
    }

    if (bits & RESOURCE_LINK) {
	lxdate_data->link_m.data = screen_data->link_m.data;
	lxdate_data->link_m.free = screen_data->link_m.free;
	lxdate_data->link_m.link = screen_data->link_m.link;
	lxdate_data->link_m.mode = screen_data->link_m.mode;
    } else {
	lxdate_data->link_m.data = NULL;
	lxdate_data->link_m.free = _x1f4_e4_free_data;
	lxdate_data->link_m.link = _x1f4_e4_link_data;
	lxdate_data->link_m.mode = _x1f4_e4_mode_data;
    }

    if (bits & TEXTFLAT_LINK) {
	lxdate_data->link_e.data = screen_data->link_e.data;
	lxdate_data->link_e.line = screen_data->link_e.line;
	lxdate_data->link_e.post = screen_data->link_e.post;
	lxdate_data->link_e.push = screen_data->link_e.push;
    } else {
	lxdate_data->link_e.data = NULL;
	lxdate_data->link_e.line = NULL;
	lxdate_data->link_e.post = NULL;
	lxdate_data->link_e.push = NULL;
    }

    status = link_date(lxdate_data, bits, screen_data);

    return status;
}


static int
line_0fix(q_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen_data->link_j.type;

    *args = line;

    linetext_data->function.count = 1;

    linetext_data->function.flags = 0;

    linetext_data->function.function = _libx1f4i0_lxdate_0_logique;

    linetext_data->function.length = 10;

    linetext_data->function.name = "d_m_second";

    linetext_data->function.type = X1f4_E4_MODE;

    return 0;
}


static int
line_0set(q_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen_data->link_l.type;

    *args = line;

    linetext_data->function.count = 1;

    linetext_data->function.flags = 0;

    linetext_data->function.function = _libx1f4i0_lxdate_0_absence;

    linetext_data->function.length = 10;

    linetext_data->function.name = "t_m_second";

    linetext_data->function.type = X1f4_E4_MODE;

    return 0;
}


static int
line_1fix(q_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen_data->link_j.type;

    *args = line;

    linetext_data->function.count = 1;

    linetext_data->function.flags = 0;

    linetext_data->function.function = _libx1f4i0_lxdate_1_logique;

    linetext_data->function.length = 10;

    linetext_data->function.name = "d_h_minute";

    linetext_data->function.type = X1f4_E4_MODE;

    return 0;
}


static int
line_1set(q_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen_data->link_l.type;

    *args = line;

    linetext_data->function.count = 1;

    linetext_data->function.flags = 0;

    linetext_data->function.function = _libx1f4i0_lxdate_1_absence;

    linetext_data->function.length = 10;

    linetext_data->function.name = "t_h_minute";

    linetext_data->function.type = X1f4_E4_MODE;

    return 0;
}


static int
line_2fix(q_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen_data->link_j.type;

    *args = line;

    linetext_data->function.count = 1;

    linetext_data->function.flags = 0;

    linetext_data->function.function = _libx1f4i0_lxdate_2_logique;

    linetext_data->function.length = 8;

    linetext_data->function.name = "d_d_hour";

    linetext_data->function.type = X1f4_E4_MODE;

    return 0;
}


static int
line_2set(q_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen_data->link_l.type;

    *args = line;

    linetext_data->function.count = 1;

    linetext_data->function.flags = 0;

    linetext_data->function.function = _libx1f4i0_lxdate_2_absence;

    linetext_data->function.length = 8;

    linetext_data->function.name = "t_d_hour";

    linetext_data->function.type = X1f4_E4_MODE;

    return 0;
}


static int
line_3fix(q_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen_data->link_j.type;

    *args = line;

    linetext_data->function.count = 1;

    linetext_data->function.flags = 0;

    linetext_data->function.function = _libx1f4i0_lxdate_3_logique;

    linetext_data->function.length = 7;

    linetext_data->function.name = "d_w_day";

    linetext_data->function.type = X1f4_E4_MODE;

    return 0;
}


static int
line_4fix(q_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen_data->link_j.type;

    *args = line;

    linetext_data->function.count = 1;

    linetext_data->function.flags = 0;

    linetext_data->function.function = _libx1f4i0_lxdate_4_logique;

    linetext_data->function.length = 7;

    linetext_data->function.name = "d_m_day";

    linetext_data->function.type = X1f4_E4_MODE;

    return 0;
}


static int
line_5fix(q_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen_data->link_j.type;

    *args = line;

    linetext_data->function.count = 1;

    linetext_data->function.flags = 0;

    linetext_data->function.function = _libx1f4i0_lxdate_5_logique;

    linetext_data->function.length = 7;

    linetext_data->function.name = "d_y_day";

    linetext_data->function.type = X1f4_E4_MODE;

    return 0;
}


static int
line_6fix(q_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen_data->link_j.type;

    *args = line;

    linetext_data->function.count = 1;

    linetext_data->function.flags = 0;

    linetext_data->function.function = _libx1f4i0_lxdate_6_logique;

    linetext_data->function.length = 9;

    linetext_data->function.name = "d_y_month";

    linetext_data->function.type = X1f4_E4_MODE;

    return 0;
}


static int
line_7fix(q_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen_data->link_j.type;

    *args = line;

    linetext_data->function.count = 1;

    linetext_data->function.flags = 0;

    linetext_data->function.function = _libx1f4i0_lxdate_7_logique;

    linetext_data->function.length = 6;

    linetext_data->function.name = "d_year";

    linetext_data->function.type = X1f4_E4_MODE;

    return 0;
}


static int
line_date(struct lxdate_type *lxdate_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    lxdate_data->link_t.datatype[0].context = lxdate_data;

    lxdate_data->link_t.datatype[0].flat = _libx1f4i0_lxdate_flat_date;
    lxdate_data->link_t.datatype[0].lead = _libx1f4i0_lxdate_lead_date;
    lxdate_data->link_t.datatype[0].line = _libx1f4i0_lxdate_line_date;
    lxdate_data->link_t.datatype[0].link = _libx1f4i0_lxdate_link_date;
    lxdate_data->link_t.datatype[0].name = "date";
    lxdate_data->link_t.datatype[0].shut = _libx1f4i0_lxdate_flat_date;
    lxdate_data->link_t.datatype[0].slip = _libx1f4i0_lxdate_slip_date;
    lxdate_data->link_t.datatype[0].size = 4;
    lxdate_data->link_t.datatype[0].type = screen_data->link_j.type;

    lxdate_data->link_t.datatype[1].context = lxdate_data;

    lxdate_data->link_t.datatype[1].flat = _libx1f4i0_lxdate_flat_time;
    lxdate_data->link_t.datatype[1].lead = _libx1f4i0_lxdate_lead_time;
    lxdate_data->link_t.datatype[1].line = _libx1f4i0_lxdate_line_time;
    lxdate_data->link_t.datatype[1].link = _libx1f4i0_lxdate_link_time;
    lxdate_data->link_t.datatype[1].name = "time";
    lxdate_data->link_t.datatype[1].shut = _libx1f4i0_lxdate_flat_time;
    lxdate_data->link_t.datatype[1].slip = _libx1f4i0_lxdate_slip_time;
    lxdate_data->link_t.datatype[1].size = 4;
    lxdate_data->link_t.datatype[1].type = screen_data->link_l.type;

    lxdate_data->link_t.datatype[2].context = NULL;

    lxdate_data->link_t.datatype[2].flat = NULL;
    lxdate_data->link_t.datatype[2].lead = NULL;
    lxdate_data->link_t.datatype[2].line = NULL;
    lxdate_data->link_t.datatype[2].link = NULL;
    lxdate_data->link_t.datatype[2].name = NULL;
    lxdate_data->link_t.datatype[2].shut = NULL;
    lxdate_data->link_t.datatype[2].slip = NULL;
    lxdate_data->link_t.datatype[2].size = 0;
    lxdate_data->link_t.datatype[2].type = 0;

    return 0;
}


static int
line_fset(q_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen_data->link_l.type;

    *args = line;

    linetext_data->function.count = 1;

    linetext_data->function.flags = 0;

    linetext_data->function.function = _libx1f4i0_lxdate_f_absence;

    linetext_data->function.length = 9;

    linetext_data->function.name = "t_s_frame";

    linetext_data->function.type = X1f4_E4_MODE;

    return 0;
}


static int
line_mset(q_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen_data->link_l.type;

    *args = line;

    linetext_data->function.count = 1;

    linetext_data->function.flags = 0;

    linetext_data->function.function = _libx1f4i0_lxdate_m_absence;

    linetext_data->function.length = 13;

    linetext_data->function.name = "t_microsecond";

    linetext_data->function.type = X1f4_E4_MODE;

    return 0;
}


static int
line_pfix(q_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen_data->link_j.type;

    *args = line;

    linetext_data->function.count = 1;

    linetext_data->function.flags = 0;

    linetext_data->function.function = _libx1f4i0_lxdate_p_logique;

    linetext_data->function.length = 9;

    linetext_data->function.name = "d_3_month";

    linetext_data->function.type = X1f4_E4_TEXT;

    return 0;
}


static int
line_qfix(q_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen_data->link_j.type;

    *args = line;

    linetext_data->function.count = 1;

    linetext_data->function.flags = 0;

    linetext_data->function.function = _libx1f4i0_lxdate_q_logique;

    linetext_data->function.length = 9;

    linetext_data->function.name = "d_n_month";

    linetext_data->function.type = X1f4_E4_TEXT;

    return 0;
}


static int
line_sset2(q_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen_data->link_l.type;

    *args = line;

    linetext_data->function.count = 1;

    linetext_data->function.flags = 0;

    linetext_data->function.function = _libx1f4i0_lxtime_s_logique;

    linetext_data->function.length = 8;

    linetext_data->function.name = "t_second";

    linetext_data->function.type = X1f4_E4_MODE;

    return 0;
}


static int
line_text(struct lxdate_type *lxdate_data, unsigned bits,
	  const struct screen_type *screen_data, void *data, void **args,
	  void **dana)
{
    struct x1f4_linetext_type *linetext_data;

    linetext_data = data;

    if (1) {
	_libx1f4i0_lxcall_side_line
	    (lxdate_data, bits, screen_data, linetext_data, args,
	     sizeof(slip_line) / sizeof(struct line_type), slip_line);
	linetext_data += sizeof(slip_line) / sizeof(struct line_type);
    }
    if (1) {
	_libx1f4i0_lxcall_side_line
	    (lxdate_data, bits, screen_data, linetext_data, args,
	     sizeof(call_line) / sizeof(struct line_type), call_line);
	linetext_data += sizeof(call_line) / sizeof(struct line_type);
    }
    if (bits & EVERLINK_SLIP) {
	_libx1f4i0_lxcall_side_line
	    (lxdate_data, bits, screen_data, linetext_data, args,
	     sizeof(ever_line) / sizeof(struct line_type), ever_line);
	linetext_data += sizeof(ever_line) / sizeof(struct line_type);
    }
    if (1) {
	line_ufix(lxdate_data, screen_data, linetext_data, args, dana);
	linetext_data++;
    }
    if (1) {
	line_pfix(lxdate_data, screen_data, linetext_data, args, dana);
	linetext_data++;
    }
    if (1) {
	line_2fix(lxdate_data, screen_data, linetext_data, args, dana);
	linetext_data++;
    }
    if (1) {
	line_1fix(lxdate_data, screen_data, linetext_data, args, dana);
	linetext_data++;
    }
    if (1) {
	line_4fix(lxdate_data, screen_data, linetext_data, args, dana);
	linetext_data++;
    }
    if (1) {
	line_0fix(lxdate_data, screen_data, linetext_data, args, dana);
	linetext_data++;
    }
    if (1) {
	line_vfix(lxdate_data, screen_data, linetext_data, args, dana);
	linetext_data++;
    }
    if (1) {
	line_qfix(lxdate_data, screen_data, linetext_data, args, dana);
	linetext_data++;
    }
    if (1) {
	line_3fix(lxdate_data, screen_data, linetext_data, args, dana);
	linetext_data++;
    }
    if (1) {
	line_5fix(lxdate_data, screen_data, linetext_data, args, dana);
	linetext_data++;
    }
    if (1) {
	line_6fix(lxdate_data, screen_data, linetext_data, args, dana);
	linetext_data++;
    }
    if (1) {
	line_7fix(lxdate_data, screen_data, linetext_data, args, dana);
	linetext_data++;
    }
    if (1) {
	line_2set(lxdate_data, screen_data, linetext_data, args, dana);
	linetext_data++;
    }
    if (1) {
	line_yset(lxdate_data, screen_data, linetext_data, args, dana);
	linetext_data++;
    }
    if (1) {
	line_1set(lxdate_data, screen_data, linetext_data, args, dana);
	linetext_data++;
    }
    if (1) {
	line_0set(lxdate_data, screen_data, linetext_data, args, dana);
	linetext_data++;
    }
    if (1) {
	line_mset(lxdate_data, screen_data, linetext_data, args, dana);
	linetext_data++;
    }
    if (1) {
	line_fset(lxdate_data, screen_data, linetext_data, args, dana);
	linetext_data++;
    }
    if (1) {
	line_sset2(lxdate_data, screen_data, linetext_data, args, dana);
	linetext_data++;
    }
    if (1) {
	line_xset(lxdate_data, screen_data, linetext_data, args, dana);
	linetext_data++;
    }
    if (1) {
	_libx1f4i0_lxcall_zero_line(linetext_data);
    }

    return 0;
}


static int
line_ufix(q_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen_data->link_j.type;

    *args = line;

    linetext_data->function.count = 1;

    linetext_data->function.flags = 0;

    linetext_data->function.function = _libx1f4i0_lxdate_3_pending;

    linetext_data->function.length = 7;

    linetext_data->function.name = "d_3_day";

    linetext_data->function.type = X1f4_E4_TEXT;

    return 0;
}


static int
line_vfix(q_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen_data->link_j.type;

    *args = line;

    linetext_data->function.count = 1;

    linetext_data->function.flags = 0;

    linetext_data->function.function = _libx1f4i0_lxdate_v_logique;

    linetext_data->function.length = 7;

    linetext_data->function.name = "d_n_day";

    linetext_data->function.type = X1f4_E4_TEXT;

    return 0;
}


static int
line_xset(q_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen_data->link_l.type;

    *args = line;

    linetext_data->function.count = 1;

    linetext_data->function.flags = 0;

    linetext_data->function.function = _libx1f4i0_lxdate_x_absence;

    linetext_data->function.length = 6;

    linetext_data->function.name = "t_sign";

    linetext_data->function.type = X1f4_E4_MODE;

    return 0;
}


static int
line_yset(q_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen_data->link_l.type;

    *args = line;

    linetext_data->function.count = 1;

    linetext_data->function.flags = 0;

    linetext_data->function.function = _libx1f4i0_lxdate_y_absence;

    linetext_data->function.length = 5;

    linetext_data->function.name = "t_day";

    linetext_data->function.type = X1f4_E4_MODE;

    return 0;
}


static int
link_date(struct lxdate_type *lxdate_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    int status;
    unsigned args_count, line_count;
    void *data;

    args_count = 0;
    line_count = 0;

    {
	args_count += slip_line_count;
	line_count += sizeof(slip_line) / sizeof(struct line_type);
    }
    if (1) {
	args_count += call_line_count;
	line_count += sizeof(call_line) / sizeof(struct line_type);
    }
    if (bits & EVERLINK_SLIP) {
	args_count += ever_line_count;
	line_count += sizeof(ever_line) / sizeof(struct line_type);
    }

    status = lxdate_data->link_w.link
	(lxdate_data->link_w.data, &data,
	 fl_size(none) + args_count * sizeof(int)
	 + line_count * sizeof(struct x1f4_linetext_type)
	 + (sizeof(struct tide_type) + sizeof(struct x1f4_operator_type *))
	 * fb_size() + sizeof(struct x1f4_operator_type *));
    if (status) {
	status = LINK_ERROR;
    } else {
	void *args, *dana, *side;

	side = (struct x1f4_linetext_type *) data + fl_page(none) + line_count;
	side = (struct tide_type *) side + fb_size();
	args = (struct x1f4_operator_type **) side + fb_size() + 1;

	lxdate_data->link_f.data = data;
	lxdate_data->link_f.side = side;

	line_text(lxdate_data, bits, screen_data, data, &args, &dana);
	_libx1f4i0_lxcall_line_side(side, data, side_o, side_f, fb_size());

	line_date(lxdate_data, bits, screen_data);
    }

    return status;
}


static void
line_afix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_j.type;
    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_cfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_j.type;
    *line++ = screen(screen)->link_j.type;

    *args = line;
}


static void
line_cset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_j.type;
    *line++ = screen(screen)->link_j.type;

    *args = line;
}


static void
line_ffix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_j.type;

    *args = line;
}


static void
line_fmap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_j.type;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_mfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_j.type;

    *args = line;
}


static void
line_nfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_j.type;

    *args = line;
}


static void
line_nset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_j.type;
    *line++ = X1f4_E4_POST_XSET;

    *args = line;
}


static void
line_ofix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_j.type;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_rfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_j.type;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_sfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_j.type;

    *args = line;
}


static void
line_sset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_j.type;
    *line++ = screen(screen)->link_j.type;
    *line++ = X1f4_E4_POST_XSET;
    *line++ = 0;

    *args = line;

    linetext_data->function.type = screen(screen)->link_j.type;
}


static void
list_cfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
list_cset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
list_dfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_j.type;
    *line++ = screen(screen)->link_j.type;

    *args = line;
}


static void
list_fmap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
list_nset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_POST_XSET;

    *args = line;
}


static void
list_sset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_POST_XSET;
    *line++ = 0;

    *args = line;

    linetext_data->function.type = screen(screen)->link_l.type;
}


int
x1f4_init_lxdate(void **lxdate, unsigned bits,
		 const struct screen_type *screen_data)
{
    int (*link) (void *, void **, unsigned), status;
    void *date, *text;

    if (bits & CODELINK_LINK) {
	link = screen_data->link_w.link;
	text = screen_data->link_w.data;
    } else {
	link = _x1f4_e4_link_data;
	text = (void *) 0;
    }

    status = link(text, &date, sizeof(struct lxdate_type));
    if (status) {
	status = LINK_ERROR;
    } else {
	status = init_date(date, bits, screen_data);
	if (status) {
	    if (bits & CODELINK_LINK) {
		screen_data->link_w.free(text, date);
	    } else {
		_x1f4_e4_free_data(text, date);
	    }
	} else {
	    *lxdate = date;
	}
    }

    return status;
}
