/*
 * lxdata-s.s.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <e4.h>
#include <lxdata-inter.h>
#include <lxdata-size.h>
#include <lxdata-types.h>

#define I_DATA(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))

int
_libx1f4i0_lxdata_s_sequent(void *context, void *output, void **input)
{
    int status;

    do {
	X1f4_E4_C_MODE mode;
	struct dxdata_type *dxdata_data, *dxdata_text;
	unsigned mine, size;

	dxdata_data = I_DATA(input[0]);

	mode = I_MODE(input[1]);

	size = dxdata_data->length;

	if (mode < 0) {
	    if ((X1f4_E4_C_MODE) size + 1 < -mode) {
		status = _libx1f4i0_lxdata_stat_time(context, size + 1, -mode);
		if (1) {
		    break;
		}
	    } else {
		mode = size + 1 + mode;
	    }
	} else {
	    if (mode < size + 1) {
	    } else {
		status = _libx1f4i0_lxdata_stat_time(context, size + 1, mode);
		if (1) {
		    break;
		}
	    }
	}

	dxdata_text = I_DATA(input[2]);

	mine = dxdata_text->length;

	if (mine) {
	    unsigned copy, rate;
	    void *text;

	    rate = size + mine;

	    if (rate < 16) {
		copy = 16;
	    } else {
		text_size(copy, rate);
	    }

	    if (size) {
		unsigned call;

		text = dxdata_data->string;

		if (size < 16) {
		    call = 16;
		} else {
		    text_size(call, size);
		}
		if (copy ^ call) {
		    struct lxdata_type *lxdata_data;

		    lxdata_data = context;

		    status = lxdata_data->link_m.mode
			(lxdata_data->link_m.data, &text, copy + 1);
		    if (status) {
			status = _libx1f4i0_lxdata_stat_mode(lxdata_data);
			if (1) {
			    break;
			}
		    } else {
			dxdata_data->string = text;
		    }
		} else {
		    status = 0;
		}

		text = (char *) text + mode;

		size -= mode;
		if (size) {
		    if (dxdata_text == dxdata_data) {
			memmove((char *) text + mine, text, size + 1);
			memmove(text, (char *) text - mode, mine);
		    } else {
			memmove((char *) text + mine, text, size + 1);
			memcpy(text, dxdata_text->string, mine);
		    }
		} else {
		    if (dxdata_text == dxdata_data) {
			char *half;

			half = text;

			half[mode] = 0;

			memcpy(half, (char *) text - mode, mode);
		    } else {
			memcpy(text, dxdata_text->string, mine + 1);
		    }
		}
	    } else {
		struct lxdata_type *lxdata_data;

		lxdata_data = context;

		status = lxdata_data->link_m.link
		    (lxdata_data->link_m.data, &text, copy + 1);
		if (status) {
		    status = _libx1f4i0_lxdata_stat_link(lxdata_data);
		    if (1) {
			break;
		    }
		} else {
		    dxdata_data->string = text;
		}

		text = (char *) text + mode;

		memcpy(text, dxdata_text->string, mine + 1);
	    }

	    dxdata_data->length = rate;
	} else {
	    status = 0;
	}
    } while (0);

    return status;
}
