/*
 * lxdata-l.p.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <e4.h>
#include <lxdata-inter.h>
#include <lxdata-size.h>
#include <lxdata-types.h>

#define I_DATA(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

int
_libx1f4i0_lxdata_p_logique(void *context, void *output, void **input)
{
    int status;

    do {
	X1f4_E4_C_MODE mode;
	char *cast;
	struct dxdata_type *dxdata_data;
	unsigned mine, size;

	dxdata_data = I_DATA(input[0]);

	mode = I_MODE(input[1]);

	size = dxdata_data->length;

	if (mode < 0) {
	    if ((X1f4_E4_C_MODE) size + 1 < -mode) {
		status = _libx1f4i0_lxdata_stat_time(context, size + 1, -mode);
		if (1) {
		    break;
		}
	    } else {
		mode = size + 1 + mode;
	    }
	} else {
	    if (mode < size + 1) {
	    } else {
		status = _libx1f4i0_lxdata_stat_time(context, size + 1, mode);
		if (1) {
		    break;
		}
	    }
	}

	cast = I_TEXT(input[2]);

	mine = strlen(cast);

	if (mine) {
	    unsigned copy, rate;
	    void *text;

	    rate = size + mine;

	    if (rate < 16) {
		copy = 16;
	    } else {
		text_size(copy, rate);
	    }

	    if (size) {
		int tier;
		unsigned call, lift;

		text = dxdata_data->string;

		tier = cast < (char *) text || (char *) text + size < cast;
		if (tier) {
		    lift = 0;
		} else {
		    lift = cast - (char *) text;
		}

		if (size < 16) {
		    call = 16;
		} else {
		    text_size(call, size);
		}
		if (copy ^ call) {
		    struct lxdata_type *lxdata_data;

		    lxdata_data = context;

		    status = lxdata_data->link_m.mode
			(lxdata_data->link_m.data, &text, copy + 1);
		    if (status) {
			status = _libx1f4i0_lxdata_stat_mode(lxdata_data);
			if (1) {
			    break;
			}
		    } else {
			dxdata_data->string = text;
		    }
		} else {
		    status = 0;
		}

		size -= mode;
		if (size) {
		    if (tier) {
			text = (char *) text + mode;

			memmove((char *) text + mine, text, size + 1);
			memcpy(text, cast, mine);
		    } else {
			struct lxdata_type *lxdata_data;
			void *cast;

			lxdata_data = context;

			status = lxdata_data->link_m.link
			    (lxdata_data->link_m.data, &cast, mine);
			if (status) {
			    status = _libx1f4i0_lxdata_stat_link(lxdata_data);
			    if (1) {
				break;
			    }
			} else {
			    memcpy(cast, (char *) text + lift, mine);

			    text = (char *) text + mode;

			    memmove((char *) text + mine, text, size + 1);
			    memcpy(text, cast, mine);

			    status = lxdata_data->link_m.free
				(lxdata_data->link_m.data, cast);
			    if (status) {
				status =
				    _libx1f4i0_lxdata_stat_free(lxdata_data);
				if (1) {
				    break;
				}
			    }
			}
		    }
		} else {
		    if (tier) {
			memcpy((char *) text + mode, cast, mine + 1);
		    } else {
			char *half;

			half = (char *) text + mode;

			half[mode] = 0;

			memcpy(half, (char *) text + lift, mode);
		    }
		}
	    } else {
		struct lxdata_type *lxdata_data;

		lxdata_data = context;

		status = lxdata_data->link_m.link
		    (lxdata_data->link_m.data, &text, copy + 1);
		if (status) {
		    status = _libx1f4i0_lxdata_stat_link(lxdata_data);
		    if (1) {
			break;
		    }
		} else {
		    dxdata_data->string = text;
		}

		text = (char *) text + mode;

		memcpy(text, cast, mine + 1);
	    }

	    dxdata_data->length = rate;
	} else {
	    status = 0;
	}
    } while (0);

    return status;
}
