/*
 * lxdata-i.a.c
 * Copyright (C) 2008-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <lxdata-inter.h>
#include <lxdata-size.h>
#include <lxdata-types.h>

#define dxdata(dxdata) \
    ((struct dxdata_type *) (dxdata))

#define lxdata(lxdata) \
    ((struct lxdata_type *) (lxdata))

int
x1f4_land_dxdata(void *lxdata, void *dxdata, const void *cast, unsigned mode)
{
    int status;

    do {
	unsigned size;

	size = dxdata(dxdata)->length;

	if (mode) {
	    unsigned copy, rate;
	    void *text;

	    rate = size + mode;

	    if (rate < 16) {
		copy = 16;
	    } else {
		text_size(copy, rate);
	    }

	    if (size) {
		int tier;
		unsigned call, lift;

		text = dxdata(dxdata)->string;

		tier = (char *) cast < (char *) text
		    || (char *) text + size < (char *) cast;
		if (tier) {
		    lift = 0;
		} else {
		    lift = (char *) cast - (char *) text;
		}

		if (size < 16) {
		    call = 16;
		} else {
		    text_size(call, size);
		}
		if (copy ^ call) {
		    status = lxdata(lxdata)->link_m.mode
			(lxdata(lxdata)->link_m.data, &text, copy + 1);
		    if (status) {
			status = _libx1f4i0_lxdata_stat_mode(lxdata);
			if (1) {
			    break;
			}
		    }
		} else {
		    status = 0;
		}

		if (tier) {
		} else {
		    char *slip;

		    dxdata(dxdata)->length = rate;
		    dxdata(dxdata)->string = text;

		    slip = text;

		    slip[rate] = 0;

		    memcpy(slip + size, slip + lift, mode);

		    if (1) {
			break;
		    }
		}
	    } else {
		status = lxdata(lxdata)->link_m.link
		    (lxdata(lxdata)->link_m.data, &text, copy + 1);
		if (status) {
		    status = _libx1f4i0_lxdata_stat_link(lxdata);
		    if (1) {
			break;
		    }
		}
	    }

	    dxdata(dxdata)->length = rate;
	    dxdata(dxdata)->string = text;

	    memcpy((char *) text + size, cast, mode);

	    *((char *) text + rate) = 0;
	} else {
	    status = 0;
	}
    } while (0);

    return status;
}
