/*
 * lxdata-e.c.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxdata-inter.h>
#include <lxdata-types.h>
#include <nt.h>

#define dxdata(data) \
    ((struct dxdata_type *) (data))

int
x1f4_free_lxdata(void *subtext, void *data,
		 struct x1f4_nodelink_type **nodetype,
		 const struct x1f4_nodelink_type *nodetype_data)
{
    int status;
    unsigned call;

    call = dxdata(data)->call;
    call--;
    if (call) {
	dxdata(data)->call = call;

	status = 0;
    } else {
	status = _libx1f4i0_lxdata_side_data(subtext, data);
    }

    return status;
}
