/*
 * lxdata-e.0.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <lxdata-inter.h>
#include <lxdata-size.h>
#include <lxdata-types.h>

extern const char *const x1f4_c1_empty_string;

int
_libx1f4i0_lxdata_bill_text(void *lxdata, void *dxdata, unsigned mode,
			    void *bill)
{
    int status;

    do {
	struct dxdata_type *dxdata_data;
	unsigned size;

	dxdata_data = dxdata;

	size = dxdata_data->length;

	if (mode) {
	    unsigned copy;
	    void *text;

	    if (mode < 16) {
		copy = 16;
	    } else {
		text_size(copy, mode);
	    }

	    if (size) {
		unsigned call;

		text = dxdata_data->string;

		if (size < 16) {
		    call = 16;
		} else {
		    text_size(call, size);
		}
		if (copy ^ call) {
		    struct lxdata_type *lxdata_data;

		    lxdata_data = lxdata;

		    status = lxdata_data->link_m.mode
			(lxdata_data->link_m.data, &text, copy + 1);
		    if (status) {
			status = _libx1f4i0_lxdata_stat_mode(lxdata_data);
			if (1) {
			    break;
			}
		    }
		} else {
		    status = 0;
		}
	    } else {
		struct lxdata_type *lxdata_data;

		lxdata_data = lxdata;

		status = lxdata_data->link_m.link
		    (lxdata_data->link_m.data, &text, copy + 1);
		if (status) {
		    status = _libx1f4i0_lxdata_stat_link(lxdata_data);
		    if (1) {
			break;
		    }
		}
	    }

	    dxdata_data->length = mode;
	    dxdata_data->string = text;

	    memcpy(text, bill, mode);

	    if (1) {
		char *dana;

		dana = text;
		dana += mode;
		*dana = 0;
	    }
	} else {
	    if (size) {
		struct lxdata_type *lxdata_data;

		lxdata_data = lxdata;

		status = lxdata_data->link_m.free
		    (lxdata_data->link_m.data, dxdata_data->string);
		if (status) {
		    status = _libx1f4i0_lxdata_stat_free(lxdata_data);
		} else {
		    dxdata_data->length = 0;
		    dxdata_data->string = (char *) x1f4_c1_empty_string;
		}
	    } else {
		status = 0;
	    }
	}
    } while (0);

    return status;
}
