/*
 * lxdata-t.d.c
 * Copyright (C) 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <e4.h>
#include <lxdata-inter.h>
#include <lxdata-types.h>

#define I_DATA(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

int
_libx1f4i0_lxdata_t_derived(void *context, void *output, void **input)
{
    int status;

    do {
	struct dxdata_type *dxdata_data;
	unsigned i, size;
	unsigned char *data, rate[256];

#if SIZEOF_UNSIGNED == 4
	if (2) {
	    unsigned call, *miss;

	    call = *(unsigned *) "\0\1\2\3";
	    miss = (unsigned *) rate;
	    size = 16;
	    for (; size; size--) {
		*miss++ = call;
		call += 0x04040404;
		*miss++ = call;
		call += 0x04040404;
		*miss++ = call;
		call += 0x04040404;
		*miss++ = call;
		call += 0x04040404;
	    }
	}
#else
	data = rate;
	size = 0;
	for (; size < 256;) {
	    *data++ = size++;
	    *data++ = size++;
	    *data++ = size++;
	    *data++ = size++;
	}
#endif				/* SIZEOF_UNSIGNED == 4 */

	if (1) {
	    unsigned c, d;
	    unsigned char *part, *slip;

	    part = (unsigned char *) I_TEXT(input[1]);
	    slip = (unsigned char *) I_TEXT(input[2]);

	    c = *part;
	    d = *slip;
	    while (!(((256 - c) | (256 - d)) & 256)) {
		rate[c] = d;
		c = *++part;
		d = *++slip;
	    }
	    if (c | d) {
		status = _libx1f4i0_lxdata_stat_late(context);
		if (1) {
		    break;
		}
	    }
	}

	status = 0;

	dxdata_data = I_DATA(input[0]);

	size = dxdata_data->length;
	data = (unsigned char *) dxdata_data->string;

	i = size >> 2;
	for (; i; i--) {
	    *data = rate[*data];
	    data++;
	    *data = rate[*data];
	    data++;
	    *data = rate[*data];
	    data++;
	    *data = rate[*data];
	    data++;
	}
	size &= 3;
	for (; size; size--) {
	    *data = rate[*data];
	    data++;
	}
    } while (0);

    return status;
}
