/*
 * lxdata-d.s.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <lxdata-inter.h>
#include <lxdata-size.h>
#include <lxdata-types.h>

#define I_DATA(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))

extern const char *const x1f4_c1_empty_string;

int
_libx1f4i0_lxdata_s_derived(void *context, void *output, void **input)
{
    X1f4_E4_C_MODE mode;
    int status;
    struct dxdata_type *dxdata_data;

    dxdata_data = I_DATA(input[0]);

    mode = I_MODE(input[1]);
    if (mode < 0) {
	status = _libx1f4i0_lxdata_stat_sign(context, mode);
    } else {
	unsigned size;

	size = dxdata_data->length;

	if (mode) {
	    unsigned copy;

	    if (mode < 16) {
		copy = 16;
	    } else {
		text_size(copy, mode);
	    }

	    if (size) {
		struct lxdata_type *lxdata_data;
		void *text;

		lxdata_data = context;

		text = dxdata_data->string;

		status = lxdata_data->link_m.mode
		    (lxdata_data->link_m.data, &text, copy + 1);
		if (status) {
		    status = _libx1f4i0_lxdata_stat_mode(lxdata_data);
		} else {
		    char *slip;

		    slip = text;
		    slip[mode] = 0;

		    dxdata_data->length = mode;
		    dxdata_data->string = text;
		}
	    } else {
		struct lxdata_type *lxdata_data;
		void *text;

		lxdata_data = context;

		status = lxdata_data->link_m.link
		    (lxdata_data->link_m.data, &text, copy + 1);
		if (status) {
		    status = _libx1f4i0_lxdata_stat_link(lxdata_data);
		} else {
		    char *slip;

		    slip = text;
		    slip[mode] = 0;

		    dxdata_data->length = mode;
		    dxdata_data->string = text;
		}
	    }
	} else {
	    if (size) {
		struct lxdata_type *lxdata_data;

		lxdata_data = context;

		status = lxdata_data->link_m.free
		    (lxdata_data->link_m.data, dxdata_data->string);
		if (status) {
		    status = _libx1f4i0_lxdata_stat_free(lxdata_data);
		} else {
		    dxdata_data->length = 0;
		    dxdata_data->string = (char *) x1f4_c1_empty_string;
		}
	    } else {
		status = 0;
	    }
	}
    }

    return status;
}
