/*
 * lxdata-a.q.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxdata-inter.h>
#include <lxdata-types.h>

extern const char *const x1f4_c1_empty_string;

int
x1f4_high_dxdata(struct lxdata_type *lxdata_data,
		 struct dxdata_type *dxdata_data)
{
    int status;

    if (dxdata_data->length) {
	status = lxdata_data->link_m.free
	    (lxdata_data->link_m.data, dxdata_data->string);
	if (status) {
	    status = _libx1f4i0_lxdata_stat_free(lxdata_data);
	} else {
	    dxdata_data->length = 0;
	    dxdata_data->string = (char *) x1f4_c1_empty_string;
	}
    } else {
	status = 0;
    }

    return status;
}
