/*
 * lxdata-a.h.c
 * Copyright (C) 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxdata-size.h>
#include <lxdata-types.h>
#include <trans.h>

extern const char *const x1f4_c1_empty_string;

static int free_data(void *, void *);
static int link_data(void *, void **, unsigned);
static int mode_data(void *, void **, unsigned);
static int near_data(void *, void **, unsigned);

static int
free_data(void *context, void *data)
{
    struct lxdata_type *lxdata_data;

    lxdata_data = context;

    return lxdata_data->link_m.free(lxdata_data->link_m.data, data);
}


static int
link_data(void *context, void **link, unsigned size)
{
    struct lxdata_type *lxdata_data;
    unsigned copy;

    size--;

    if (size < 16) {
	copy = 16;
    } else {
	text_size(copy, size);
    }

    lxdata_data = context;

    return lxdata_data->link_m.link(lxdata_data->link_m.data, link, copy + 1);
}


static int
mode_data(void *context, void **link, unsigned size)
{
    int status;

    if (*link == x1f4_c1_empty_string) {
	status = link_data(context, link, size);
    } else {
	status = near_data(context, link, size);
    }

    return status;
}


static int
near_data(void *context, void **link, unsigned size)
{
    struct lxdata_type *lxdata_data;
    unsigned copy;

    size--;

    if (size < 16) {
	copy = 16;
    } else {
	text_size(copy, size);
    }

    lxdata_data = context;

    return lxdata_data->link_m.mode(lxdata_data->link_m.data, link, copy + 1);
}


int
x1f4_hold_lxdata(void *lxdata, struct trans_type *trans_data)
{
    trans_data->data = lxdata;

    trans_data->free = free_data;
    trans_data->link = link_data;
    trans_data->mode = mode_data;

    return 0;
}
