/*
 * lxdata-a.g.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <lxdata-inter.h>
#include <lxdata-types.h>

extern const char *const x1f4_c1_empty_string;

int
x1f4_line_lxdata(void *subtext, void **address)
{
    int status;
    struct lxdata_type *lxdata_data;
    void *dxdata;

    lxdata_data = subtext;

    status = lxdata_data->link_m.link
	(lxdata_data->link_m.data, &dxdata, sizeof(struct dxdata_type));
    if (status) {
	status = _libx1f4i0_lxdata_stat_link(lxdata_data);
    } else {
	((struct dxdata_type *) dxdata)->call = 1;

	((struct dxdata_type *) dxdata)->length = 0;
	((struct dxdata_type *) dxdata)->string =
	    (char *) x1f4_c1_empty_string;

	*address = dxdata;
    }

    return status;
}
