/*
 * lxdata-a.e.c
 * Copyright (C) 2008-2010, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <er.h>
#include <exerrors.h>
#include <lxdata-inter.h>
#include <lxdata-types.h>

#define lxdata(lxdata) \
    ((struct lxdata_type *) (lxdata))

int
_libx1f4i0_lxdata_stat_deck(void *lxdata, unsigned size, long mode)
{
    if (size) {
	_libx1f4i0_lxdata_stat_time(lxdata, size, mode);
    } else {
	_libx1f4i0_lxdata_stat_null(lxdata);
    }

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxdata_stat_free(void *lxdata)
{
    LINE_EEER(lxdata(lxdata)->link_e);

    PUSH_DATA("cannot free memory", 18);

    POST_EEER();

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxdata_stat_late(void *lxdata)
{
    LINE_EEER(lxdata(lxdata)->link_e);

    PUSH_DATA("translation string lengths do not match", 39);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;	
}


int
_libx1f4i0_lxdata_stat_link(void *lxdata)
{
    LINE_EEER(lxdata(lxdata)->link_e);

    PUSH_DATA("cannot allocate memory", 22);

    POST_EEER();

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxdata_stat_mode(void *lxdata)
{
    LINE_EEER(lxdata(lxdata)->link_e);

    PUSH_DATA("cannot reallocate memory", 24);

    POST_EEER();

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxdata_stat_null(void *lxdata)
{
    LINE_EEER(lxdata(lxdata)->link_e);

    PUSH_DATA("empty byte array", 16);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxdata_stat_sign(void *lxdata, long mode)
{
    LINE_EEER(lxdata(lxdata)->link_e);

    PUSH_DATA("negative size indication (", 26);
    PUSH_LONG(mode);
    PUSH_DATA(")", 1);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxdata_stat_time(void *lxdata, unsigned size, long mode)
{
    LINE_EEER(lxdata(lxdata)->link_e);

    PUSH_DATA("out of valid range (-", 21);
    PUSH_BILL(size);
    PUSH_DATA(" .. ", 4);
    PUSH_BILL(size - 1);
    PUSH_DATA(") data index (", 14);
    PUSH_LONG(mode);
    PUSH_DATA(")", 1);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}
