/*
 * lxdata-a.c.c
 * Copyright (C) 2008, 2009, 2010, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lxdata-inter.h>
#include <lxdata-types.h>

extern const char *const x1f4_c1_empty_string;

int
_libx1f4i0_lxdata_side_data(void *subtext, void *data)
{
    int status;
    struct dxdata_type *dxdata_data;

    dxdata_data = data;
    if (!dxdata_data) {
	/*
	 * dxdata_data may well be null... - test may not be removed.
	 */

	status = 0;
    } else {
	do {
	    char *string;

	    string = dxdata_data->string;
	    if (string != x1f4_c1_empty_string) {
		status = ((struct lxdata_type *) subtext)->link_m.free
		    (((struct lxdata_type *) subtext)->link_m.data, string);
		if (status) {
		    status = _libx1f4i0_lxdata_stat_free(subtext);
		    if (1) {
			break;
		    }
		}
	    }

	    {
		status = ((struct lxdata_type *) subtext)->link_m.free
		    (((struct lxdata_type *) subtext)->link_m.data,
		     dxdata_data);
		if (status) {
		    status = _libx1f4i0_lxdata_stat_free(subtext);

		    if (1) {
			dxdata_data->length = 0;
			dxdata_data->string = (char *) x1f4_c1_empty_string;
		    }
		}
	    }
	} while (0);
    }

    return status;
}
