/*
 * lxdata-a.b.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <lxdata-inter.h>
#include <lxdata-size.h>
#include <lxdata-types.h>
#include <nt.h>

#define dxdata(data) \
    ((struct dxdata_type *) (data))

extern const char *const x1f4_c1_empty_string;

int
x1f4_copy_lxdata(void *subtext, void *bppp, void **copy, const void *data,
		 const struct x1f4_nodelink_type *nodetype_data)
{
    int status;
    struct lxdata_type *lxdata_data;
    void *dxdata;

    lxdata_data = subtext;

    status = lxdata_data->link_m.link
	(lxdata_data->link_m.data, &dxdata, sizeof(struct dxdata_type));
    if (status) {
	status = _libx1f4i0_lxdata_stat_link(lxdata_data);
    } else {
	do {
	    unsigned length;

	    length = dxdata(data)->length;
	    if (length) {
		unsigned copy;
		void *string;

		if (length < 16) {
		    copy = 16;
		} else {
		    text_size(copy, length);
		}

		status = lxdata_data->link_m.link
		    (lxdata_data->link_m.data, &string, copy + 1);
		if (status) {
		    status = _libx1f4i0_lxdata_stat_link(lxdata_data);

		    lxdata_data->link_m.free
			(lxdata_data->link_m.data, dxdata);

		    break;
		} else {
		    dxdata(dxdata)->length = length;
		    dxdata(dxdata)->string = string;

		    memcpy(string, dxdata(data)->string, length + 1);
		}
	    } else {
		dxdata(dxdata)->length = 0;
		dxdata(dxdata)->string = (char *) x1f4_c1_empty_string;
	    }

	    ((struct dxdata_type *) dxdata)->call = 1;

	    *copy = dxdata;
	} while (0);
    }

    return status;
}
